/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.SAXParserFactory;
import org.glassfish.hk2.api.Factory;
import org.glassfish.jersey.message.internal.AbstractJaxbElementProvider;

public abstract class XmlJaxbElementProvider
extends AbstractJaxbElementProvider {
    private final Factory<SAXParserFactory> spf;

    public XmlJaxbElementProvider(Factory<SAXParserFactory> spf, Providers ps) {
        super(ps);
        this.spf = spf;
    }

    public XmlJaxbElementProvider(Factory<SAXParserFactory> spf, Providers ps, MediaType mt) {
        super(ps, mt);
        this.spf = spf;
    }

    @Override
    protected final JAXBElement<?> readFrom(Class<?> type, MediaType mediaType, Unmarshaller u, InputStream entityStream) throws JAXBException {
        return u.unmarshal(XmlJaxbElementProvider.getSAXSource(this.spf.provide(), entityStream), type);
    }

    @Override
    protected final void writeTo(JAXBElement<?> t, MediaType mediaType, Charset c, Marshaller m3, OutputStream entityStream) throws JAXBException {
        m3.marshal(t, entityStream);
    }

    @Produces(value={"*/*,*/*+xml"})
    @Consumes(value={"*/*,*/*+xml"})
    @Singleton
    public static final class General
    extends XmlJaxbElementProvider {
        public General(@Context Factory<SAXParserFactory> spf, @Context Providers ps) {
            super(spf, ps);
        }

        @Override
        protected boolean isSupported(MediaType m3) {
            return m3.getSubtype().endsWith("+xml");
        }
    }

    @Produces(value={"text/xml"})
    @Consumes(value={"text/xml"})
    @Singleton
    public static final class Text
    extends XmlJaxbElementProvider {
        public Text(@Context Factory<SAXParserFactory> spf, @Context Providers ps) {
            super(spf, ps, MediaType.TEXT_XML_TYPE);
        }
    }

    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    @Singleton
    public static final class App
    extends XmlJaxbElementProvider {
        public App(@Context Factory<SAXParserFactory> spf, @Context Providers ps) {
            super(spf, ps, MediaType.APPLICATION_XML_TYPE);
        }
    }
}

