/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain.input;

import com.atlassian.jira.rest.client.api.domain.EntityHelper;
import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import com.atlassian.jira.rest.client.api.domain.input.PropertyInput;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IssueInput {
    private final Map<String, FieldInput> fields;
    private final List<PropertyInput> properties;

    public static IssueInput createWithFields(FieldInput ... fields) {
        return new IssueInput(Maps.uniqueIndex(ImmutableList.copyOf(fields), EntityHelper.GET_ENTITY_STRING_ID_FUNCTION), new ArrayList<PropertyInput>());
    }

    public IssueInput(Map<String, FieldInput> fields, List<PropertyInput> properties) {
        this.fields = fields;
        this.properties = properties;
    }

    public Map<String, FieldInput> getFields() {
        return this.fields;
    }

    public List<PropertyInput> getProperties() {
        return this.properties;
    }

    public FieldInput getField(String id) {
        return this.fields.get(id);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("fields", this.fields).add("properties", this.properties).toString();
    }
}

