/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.ip;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opennms.protocols.ip.IPv4Address;
import org.opennms.protocols.ip.UnknownIPVersionException;

public class IPHeader {
    public static final int IP_VERSION = 4;
    public static final int TOS_PRECEDENCE_MASK = 224;
    public static final int TOS_PRECEDENCE_NETWORK_CRITICAL = 224;
    public static final int TOS_PRECEDENCE_INTERNETWORK_CONTROL = 192;
    public static final int TOS_PRECEDENCE_CRITICAL_ECP = 144;
    public static final int TOS_PRECEDENCE_FLASH_OVERRIDE = 128;
    public static final int TOS_PRECEDENCE_FLASH = 96;
    public static final int TOS_PRECEDENCE_IMMEDIATE = 64;
    public static final int TOS_PRECEDENCE_PRIORITY = 32;
    public static final int TOS_PRECEDENCE_ROUTINE = 0;
    public static final int TOS_DELAY_MASK = 16;
    public static final int TOS_DELAY_LOW = 16;
    public static final int TOS_DELAY_NORMAL = 0;
    public static final int TOS_THROUGHPUT_MASK = 8;
    public static final int TOS_THROUGHPUT_HIGH = 8;
    public static final int TOS_THROUGHPUT_NORMAL = 0;
    public static final int TOS_RELIBILITY_MASK = 4;
    public static final int TOS_RELIBILITY_HIGH = 4;
    public static final int TOS_RELIBILITY_NORMAL = 0;
    public static final int TOS_RESERVED_MASK = 3;
    public static final int FLAGS_MASK = 57344;
    public static final int FLAGS_DONT_FRAGMENT = 16384;
    public static final int FLAGS_MORE_FRAGMENTS = 8192;
    public static final int OPTION_COPY_MASK = 128;
    public static final int OPTION_CLASS_MASK = 96;
    public static final int OPTION_NUMBER_MASK = 31;
    public static final int OPTION_ID_EOO = 0;
    public static final int OPTION_ID_LOOSE_SOURCE_ROUTING = 131;
    public static final int OPTION_ID_STRICT_SOURCE_ROUTING = 137;
    public static final int OPTION_ID_ROUTE_RECORD = 7;
    private byte m_version;
    private byte m_hdrlen;
    private byte m_tos;
    private short m_length;
    private short m_identity;
    private byte m_flags;
    private short m_fragOffset;
    private byte m_ttl;
    private byte m_protocol;
    private short m_checksum;
    private int m_srcAddr;
    private int m_dstAddr;
    private byte[] m_options;

    private byte[] dup(byte[] src) {
        byte[] cpy = null;
        if (src != null) {
            cpy = new byte[src.length];
            System.arraycopy(src, 0, cpy, 0, src.length);
        }
        return cpy;
    }

    private static short byteToShort(byte b) {
        short r = b;
        if (r < 0) {
            r = (short)(r + 256);
        }
        return r;
    }

    private static int byteToInt(byte b) {
        int r = b;
        if (r < 0) {
            r += 256;
        }
        return r;
    }

    private static int shortToInt(short s) {
        int r = s;
        if (r < 0) {
            r += 65536;
        }
        return r;
    }

    public IPHeader() {
        this.m_hdrlen = (byte)5;
        this.m_version = (byte)4;
        this.m_tos = 0;
        this.m_length = (short)20;
        this.m_identity = 0;
        this.m_flags = 0;
        this.m_fragOffset = 0;
        this.m_ttl = (byte)30;
        this.m_protocol = 0;
        this.m_checksum = 0;
        this.m_srcAddr = 0;
        this.m_dstAddr = 0;
        this.m_options = new byte[0];
    }

    public IPHeader(IPHeader second) {
        this.m_hdrlen = second.m_hdrlen;
        this.m_version = second.m_version;
        this.m_tos = second.m_tos;
        this.m_length = second.m_length;
        this.m_identity = second.m_identity;
        this.m_flags = second.m_flags;
        this.m_fragOffset = second.m_fragOffset;
        this.m_ttl = second.m_ttl;
        this.m_protocol = second.m_protocol;
        this.m_checksum = second.m_checksum;
        this.m_srcAddr = second.m_srcAddr;
        this.m_dstAddr = second.m_dstAddr;
        this.m_options = this.dup(second.m_options);
    }

    public IPHeader(byte[] header, int offset) {
        int length = header.length;
        if (length - offset < 20) {
            throw new IndexOutOfBoundsException("Minimum IP header size is 20 bytes");
        }
        int ndx = 0;
        this.m_version = (byte)(header[offset + ndx] >>> 4);
        this.m_hdrlen = (byte)(header[offset + ndx] & 0xF);
        ++ndx;
        if (this.m_version != 4) {
            throw new UnknownIPVersionException("Unknown IP Version, version = " + this.m_version);
        }
        if (length - offset < this.m_hdrlen * 4) {
            throw new IndexOutOfBoundsException("Insufficient data: buffer size = " + (length - offset) + " and header length = " + this.m_hdrlen * 4);
        }
        this.m_tos = header[offset + ndx];
        this.m_length = (short)(IPHeader.byteToShort(header[offset + ++ndx]) << 8 | IPHeader.byteToShort(header[offset + ndx + 1]));
        this.m_identity = (short)(IPHeader.byteToShort(header[offset + (ndx += 2)]) << 8 | IPHeader.byteToShort(header[offset + ndx + 1]));
        this.m_fragOffset = (short)(IPHeader.byteToShort(header[offset + (ndx += 2)]) << 8 | IPHeader.byteToShort(header[offset + ndx + 1]));
        this.m_flags = (byte)(this.m_fragOffset >>> 13);
        this.m_fragOffset = (short)(this.m_fragOffset & 0x1FFF);
        this.m_ttl = header[offset + (ndx += 2)];
        this.m_protocol = header[offset + ++ndx];
        this.m_checksum = (short)(IPHeader.byteToShort(header[offset + ++ndx]) << 8 | IPHeader.byteToShort(header[offset + ndx + 1]));
        this.m_srcAddr = IPHeader.byteToInt(header[offset + (ndx += 2)]) << 24 | IPHeader.byteToInt(header[offset + ndx + 1]) << 16 | IPHeader.byteToInt(header[offset + ndx + 2]) << 8 | IPHeader.byteToInt(header[offset + ndx + 3]);
        this.m_dstAddr = IPHeader.byteToInt(header[offset + (ndx += 4)]) << 24 | IPHeader.byteToInt(header[offset + ndx + 1]) << 16 | IPHeader.byteToInt(header[offset + ndx + 2]) << 8 | IPHeader.byteToInt(header[offset + ndx + 3]);
        int hl = IPHeader.byteToInt(this.m_hdrlen) << 2;
        if (hl > (ndx += 4)) {
            this.m_options = new byte[hl - ndx];
            int x = 0;
            while (ndx < hl) {
                this.m_options[x++] = header[offset + ndx++];
            }
        } else {
            this.m_options = new byte[0];
        }
    }

    public byte getVersion() {
        return this.m_version;
    }

    public int getHeaderLength() {
        return 4 * IPHeader.byteToInt(this.m_hdrlen);
    }

    public byte getTypeOfService() {
        return this.m_tos;
    }

    public void setTypeOfService(byte tos) {
        this.m_tos = tos;
    }

    public boolean getTypeOfService(int bit) {
        if (bit >= 0 && bit < 8) {
            return (this.m_tos & 1 << bit) != 0;
        }
        return false;
    }

    public int getPacketLength() {
        return IPHeader.shortToInt(this.m_length);
    }

    public void setPacketLength(short length) {
        this.m_length = length;
    }

    public short getIdentity() {
        return this.m_identity;
    }

    public void setIdentity(short ident) {
        this.m_identity = ident;
    }

    public byte getFlags() {
        return this.m_flags;
    }

    public void setFlags(byte flags) {
        this.m_flags = flags;
    }

    public boolean getFlag(int bit) {
        if (bit >= 0 && bit < 3) {
            return (this.m_flags & 1 << bit) != 0;
        }
        return false;
    }

    public short getFragmentOffset() {
        return this.m_fragOffset;
    }

    public void setFragmentOffset(short offset) {
        this.m_fragOffset = offset;
    }

    public byte getTTL() {
        return this.m_ttl;
    }

    public void setTTL(byte ttl) {
        this.m_ttl = ttl;
    }

    public byte getProtocol() {
        return this.m_protocol;
    }

    public void setProtocol(byte protocol) {
        this.m_protocol = protocol;
    }

    public short getChecksum() {
        return this.m_checksum;
    }

    public void setChecksum(short sum) {
        this.m_checksum = sum;
    }

    public int getSourceAddress() {
        return this.m_srcAddr;
    }

    public void setSourceAddr(int addr) {
        this.m_srcAddr = addr;
    }

    public int getDestinationAddress() {
        return this.m_dstAddr;
    }

    public void setDestinationAddress(int addr) {
        this.m_dstAddr = addr;
    }

    public byte[] getOptionData() {
        return this.m_options;
    }

    public void setOptionData(byte[] options) {
        this.m_options = options;
        this.m_hdrlen = (byte)((20 + this.m_options.length) / 4);
    }

    public List<Option> getOptions() throws InstantiationException {
        if (this.m_options == null) {
            return new ArrayList<Option>();
        }
        ArrayList<Option> options = new ArrayList<Option>();
        int offset = 0;
        block6: while (offset < this.m_options.length) {
            switch (this.m_options[offset++] & 0xFF) {
                case 0: {
                    options.add(new EndOfOptions());
                    continue block6;
                }
                case 131: {
                    int j;
                    int ip;
                    int i;
                    RouteOption opt = new LooseSourceRouteOption();
                    int addrs = (this.m_options[offset] & 0xFF) - 3;
                    offset += 2;
                    for (i = 0; i < addrs / 4; ++i) {
                        ip = 0;
                        for (j = 0; j < 4; ++j) {
                            ip <<= 8 + (this.m_options[offset++] & 0xFF);
                        }
                        opt.add(new IPv4Address(ip));
                    }
                    options.add(opt);
                    continue block6;
                }
                case 137: {
                    int j;
                    int ip;
                    int i;
                    RouteOption opt = new StrictSourceRouteOption();
                    int addrs = (this.m_options[offset] & 0xFF) - 3;
                    offset += 2;
                    for (i = 0; i < addrs / 4; ++i) {
                        ip = 0;
                        for (j = 0; j < 4; ++j) {
                            ip <<= 8 + (this.m_options[offset++] & 0xFF);
                        }
                        opt.add(new IPv4Address(ip));
                    }
                    options.add(opt);
                    continue block6;
                }
                case 7: {
                    int j;
                    int ip;
                    int i;
                    RouteOption opt = new LooseSourceRouteOption();
                    int addrs = (this.m_options[offset] & 0xFF) - 3;
                    offset += 2;
                    for (i = 0; i < addrs / 4; ++i) {
                        ip = 0;
                        for (j = 0; j < 4; ++j) {
                            ip <<= 8 + (this.m_options[offset++] & 0xFF);
                        }
                        opt.add(new IPv4Address(ip));
                    }
                    options.add(opt);
                    continue block6;
                }
            }
            throw new InstantiationException("Unsupported Option Type");
        }
        return options;
    }

    public void addOption(Option opt) {
        int origLen = 0;
        if (this.m_options == null) {
            int len = opt.bytesRequired();
            if (len % 4 != 0) {
                len = 4 - len % 4;
            }
            this.m_options = new byte[opt.bytesRequired()];
            int off = opt.writeBytes(this.m_options, 0);
            while (off < len) {
                this.m_options[off++] = 0;
            }
        } else {
            origLen = this.m_options.length;
            if (origLen + opt.bytesRequired() > 40) {
                throw new IndexOutOfBoundsException("Option List is too long, must be less than 40 bytes");
            }
            int len = origLen + opt.bytesRequired();
            if (len % 4 != 0) {
                len += 4 - len % 4;
            }
            byte[] ndata = new byte[len];
            System.arraycopy(this.m_options, 0, ndata, 0, origLen);
            int off = opt.writeBytes(ndata, origLen);
            while (off < len) {
                ndata[off++] = 0;
            }
        }
        this.m_hdrlen = (byte)((20 + this.m_options.length) / 4);
    }

    public int writeBytes(byte[] data, int offset) {
        data[offset++] = (byte)(this.m_version << 4 | this.m_hdrlen & 0xF);
        data[offset++] = this.m_tos;
        data[offset++] = (byte)(this.m_length >> 8 & 0xFF);
        data[offset++] = (byte)(this.m_length & 0xFF);
        data[offset++] = (byte)(this.m_identity >> 8 & 0xFF);
        data[offset++] = (byte)(this.m_identity & 0xFF);
        data[offset++] = (byte)(this.m_flags << 5 | this.m_fragOffset >> 8 & 0xFF);
        data[offset++] = (byte)(this.m_fragOffset & 0xFF);
        data[offset++] = this.m_ttl;
        data[offset++] = this.m_protocol;
        data[offset++] = (byte)(this.m_checksum >> 8 & 0xFF);
        data[offset++] = (byte)(this.m_checksum & 0xFF);
        data[offset++] = (byte)(this.m_srcAddr >> 24 & 0xFF);
        data[offset++] = (byte)(this.m_srcAddr >> 16 & 0xFF);
        data[offset++] = (byte)(this.m_srcAddr >> 8 & 0xFF);
        data[offset++] = (byte)(this.m_srcAddr & 0xFF);
        data[offset++] = (byte)(this.m_dstAddr >> 24 & 0xFF);
        data[offset++] = (byte)(this.m_dstAddr >> 16 & 0xFF);
        data[offset++] = (byte)(this.m_dstAddr >> 8 & 0xFF);
        data[offset++] = (byte)(this.m_dstAddr & 0xFF);
        System.arraycopy(this.m_options, 0, data, offset, this.m_options.length);
        return offset += this.m_options.length;
    }

    public static String addressToString(int ipv4Addr) {
        StringBuffer buf = new StringBuffer();
        buf.append(ipv4Addr >> 24 & 0xFF);
        buf.append('.');
        buf.append(ipv4Addr >> 16 & 0xFF);
        buf.append('.');
        buf.append(ipv4Addr >> 8 & 0xFF);
        buf.append('.');
        buf.append(ipv4Addr & 0xFF);
        return buf.toString();
    }

    public static String addressToString(byte[] buf) {
        if (buf.length != 4) {
            throw new IllegalArgumentException("IPv4 Address must be 4-bytes in length");
        }
        int a = buf[0] < 0 ? buf[0] + 256 : buf[0];
        int b = buf[1] < 0 ? buf[1] + 256 : buf[1];
        int c = buf[2] < 0 ? buf[2] + 256 : buf[2];
        int d = buf[3] < 0 ? buf[3] + 256 : buf[3];
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(a).append('.').append(b).append('.').append(c).append('.').append(d);
        return sbuf.toString();
    }

    public static final class RouteRecordOption
    extends RouteOption {
        RouteRecordOption() {
            super((byte)7);
        }

        public RouteRecordOption(int capacity) {
            super((byte)7);
            for (int i = 0; i < capacity; ++i) {
                this.add(new IPv4Address(0));
            }
        }

        public RouteRecordOption(IPv4Address[] addrs) {
            super((byte)7, addrs);
        }

        public RouteRecordOption(List<IPv4Address> addrs) {
            super((byte)7, addrs);
        }
    }

    public static final class StrictSourceRouteOption
    extends RouteOption {
        StrictSourceRouteOption() {
            super((byte)-119);
        }

        public StrictSourceRouteOption(IPv4Address[] addrs) {
            super((byte)-119, addrs);
        }

        public StrictSourceRouteOption(List<IPv4Address> addrs) {
            super((byte)-119, addrs);
        }
    }

    public static final class LooseSourceRouteOption
    extends RouteOption {
        LooseSourceRouteOption() {
            super((byte)-125);
        }

        public LooseSourceRouteOption(IPv4Address[] addrs) {
            super((byte)-125, addrs);
        }

        public LooseSourceRouteOption(List<IPv4Address> addrs) {
            super((byte)-125, addrs);
        }
    }

    public static class RouteOption
    extends Option {
        protected List<IPv4Address> m_addrs;

        void add(IPv4Address addr) {
            if (this.m_addrs.size() == 9) {
                throw new IndexOutOfBoundsException("The address could not be added, the record is full");
            }
            this.m_addrs.add(addr);
        }

        @Override
        int bytesRequired() {
            return 3 + 4 * this.m_addrs.size();
        }

        @Override
        int writeBytes(byte[] dest, int offset) {
            dest[offset++] = (byte)this.m_code;
            dest[offset++] = (byte)this.bytesRequired();
            dest[offset++] = 4;
            Iterator<IPv4Address> iter = this.m_addrs.iterator();
            while (iter.hasNext()) {
                int addr = iter.next().getAddress();
                for (int i = 3; i >= 0; ++i) {
                    dest[offset++] = (byte)(addr >> 8 * i & 0xFF);
                }
            }
            return offset;
        }

        RouteOption(byte code) {
            super(code);
            this.m_addrs = new ArrayList<IPv4Address>(9);
        }

        RouteOption(byte code, IPv4Address[] addrs) {
            super(code);
            if (addrs.length > 9) {
                throw new IndexOutOfBoundsException("Route Option List Cannot Exceed 9 Addresses");
            }
            this.m_addrs = new ArrayList<IPv4Address>(9);
            for (int i = 0; i < addrs.length; ++i) {
                this.m_addrs.add(addrs[i]);
            }
        }

        RouteOption(byte code, List<IPv4Address> addrs) {
            super(code);
            if (addrs.size() > 9) {
                throw new IndexOutOfBoundsException("Route Option List Cannot Exceed 9 Addresses");
            }
            Iterator<IPv4Address> iter = addrs.iterator();
            this.m_addrs = new ArrayList<IPv4Address>(9);
            while (iter.hasNext()) {
                this.m_addrs.add(iter.next());
            }
        }

        public Iterator<IPv4Address> iterator() {
            return this.m_addrs.iterator();
        }

        public int size() {
            return this.m_addrs.size();
        }
    }

    public static final class EndOfOptions
    extends Option {
        @Override
        int bytesRequired() {
            return 1;
        }

        @Override
        int writeBytes(byte[] dest, int offset) {
            dest[offset++] = 0;
            return offset;
        }

        public EndOfOptions() {
            super((byte)0);
        }
    }

    public static abstract class Option {
        protected int m_code;
        public static final int CODE_END_OF_OPTION_LIST = 0;
        public static final int CODE_LOOSE_SOURCE_ROUTE = 131;
        public static final int CODE_STRICT_SOURCE_ROUTE = 137;
        public static final int CODE_ROUTE_RECORD = 7;

        protected Option(byte code) {
            this.m_code = code & 0xFF;
        }

        abstract int bytesRequired();

        abstract int writeBytes(byte[] var1, int var2);

        public int getOptionClass() {
            return this.m_code & 0x60;
        }

        public int getOptionNumber() {
            return this.m_code & 0x1F;
        }

        public boolean isOptionCopied() {
            return (this.m_code & 0x80) != 0;
        }
    }
}

