/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import org.opennms.protocols.icmp.ICMPHeader;
import org.opennms.protocols.ip.OC16ChecksumProducer;

public final class AddressMaskRequest
extends ICMPHeader {
    public AddressMaskRequest() {
        super((byte)17, (byte)0);
    }

    public AddressMaskRequest(byte[] buf, int offset) {
        this.loadFromBuffer(buf, offset);
    }

    @Override
    public final void computeChecksum() {
        OC16ChecksumProducer summer = new OC16ChecksumProducer();
        super.computeChecksum(summer);
        summer.add(0);
        this.setChecksum(summer.getChecksum());
    }

    @Override
    public final int storeToBuffer(byte[] buf, int offset) {
        if (buf.length < offset + 12) {
            throw new IndexOutOfBoundsException("Array index overflow in buffer build");
        }
        this.computeChecksum();
        offset = super.storeToBuffer(buf, offset);
        for (int x = 0; x < 4; ++x) {
            buf[offset++] = 0;
        }
        return offset;
    }

    @Override
    public final int loadFromBuffer(byte[] buf, int offset) {
        if (buf.length < offset + 12) {
            throw new IndexOutOfBoundsException("Insufficient data to load ICMP header");
        }
        offset = super.loadFromBuffer(buf, offset);
        if (this.getType() != 17) {
            throw new IllegalArgumentException("The buffer did not contain an Address Mask Request");
        }
        return offset += 4;
    }

    @Override
    public final byte[] toBytes() {
        byte[] b = new byte[12];
        this.storeToBuffer(b, 0);
        return b;
    }
}

