/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.newts.support.osgi;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.newts.support.SearchableResourceMetadataCache;
import org.opennms.netmgt.newts.support.osgi.CacheFactory;
import org.opennms.newts.api.Context;
import org.opennms.newts.cassandra.search.CassandraIndexingOptions;

public class OsgiUtils {
    public static Context createContext() {
        return Context.DEFAULT_CONTEXT;
    }

    public static CassandraIndexingOptions createIndexOptions(int maxBatchSize) {
        return new CassandraIndexingOptions.Builder().withHierarchicalIndexing(false).withIndexResourceTerms(false).withIndexUsingDefaultTerm(false).withMaxBatchSize(maxBatchSize).build();
    }

    public static <T extends SearchableResourceMetadataCache> T createCache(String cacheType, List<CacheFactory> factories) {
        Objects.requireNonNull(cacheType);
        Objects.requireNonNull(factories);
        try {
            Class<?> cacheClass = Class.forName(cacheType);
            Optional<CacheFactory> cacheFactory = factories.stream().filter(f -> f.supportedType() == cacheClass).findFirst();
            if (cacheFactory.isPresent()) {
                return (T)((SearchableResourceMetadataCache)cacheFactory.get().createCache());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        throw new IllegalArgumentException("No cache of type " + cacheType + " found.");
    }
}

