/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.newts.support;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Duration;
import org.opennms.newts.cassandra.ContextConfigurations;

public class ContextConfigurationFactory {
    public static ContextConfigurations getContextConfigurations() {
        return ContextConfigurationFactory.getContextConfigurations(System.getProperty("org.opennms.newts.config.resource_shard", "604800"), System.getProperty("org.opennms.newts.config.read_consistency", "ONE"), System.getProperty("org.opennms.newts.config.write_consistency", "ANY"));
    }

    public static ContextConfigurations getContextConfigurations(String resourceShardStr, String readConsistencyStr, String writeConsistencyStr) {
        Duration resourceShard = Duration.seconds((long)Long.parseLong(resourceShardStr));
        DefaultConsistencyLevel readConsistency = DefaultConsistencyLevel.valueOf((String)readConsistencyStr);
        DefaultConsistencyLevel writeConsistency = DefaultConsistencyLevel.valueOf((String)writeConsistencyStr);
        ContextConfigurations contexts = new ContextConfigurations();
        contexts.addContextConfig(Context.DEFAULT_CONTEXT, resourceShard, (ConsistencyLevel)readConsistency, (ConsistencyLevel)writeConsistency);
        return contexts;
    }
}

