/*
 * Decompiled with CFR 0.152.
 */
package geo.google.mapping;

import geo.google.GeoException;
import geo.google.datamodel.GeoAddress;
import geo.google.datamodel.GeoUsAddress;
import geo.google.mapping.AddressToUsAddressFunctor;
import geo.google.mapping.XmlMappingFunctor;
import geo.google.mapping.XmlToAddressFunctor;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlToUsAddressFunctor
implements XmlMappingFunctor<List<GeoUsAddress>> {
    private static final XmlToUsAddressFunctor _instance = new XmlToUsAddressFunctor();

    public static XmlToUsAddressFunctor getInstance() {
        return _instance;
    }

    @Override
    public List<GeoUsAddress> execute(String xml) throws GeoException {
        try {
            List<GeoAddress> geoAddrs = XmlToAddressFunctor.getInstance().execute(xml);
            ArrayList<GeoUsAddress> ret = new ArrayList<GeoUsAddress>(geoAddrs.size());
            for (GeoAddress geoAddr : geoAddrs) {
                ret.add(AddressToUsAddressFunctor.getInstance().execute(geoAddr));
            }
            return ret;
        }
        catch (GeoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeoException(e);
        }
    }
}

