/*
 * Decompiled with CFR 0.152.
 */
package geo.google.mapping;

import geo.google.GeoException;
import geo.google.mapping.XmlMappingFunctor;
import java.io.ByteArrayOutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTMappingFunctor
implements XmlMappingFunctor<String> {
    private Source _xsltSource;

    public XSLTMappingFunctor(Source xsltSource) {
        this._xsltSource = xsltSource;
    }

    public Source getXsltSource() {
        return this._xsltSource;
    }

    public void setXsltSource(Source xsltSource) {
        this._xsltSource = xsltSource;
    }

    @Override
    public String execute(String xml) throws GeoException {
        StreamSource source = new StreamSource(xml);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult res = new StreamResult(out);
        TransformerFactory transFact = TransformerFactory.newInstance();
        try {
            Transformer trans = transFact.newTransformer(this._xsltSource);
            trans.transform(source, res);
        }
        catch (TransformerConfigurationException e) {
            throw new GeoException(e);
        }
        catch (TransformerException e) {
            throw new GeoException(e);
        }
        return out.toString();
    }
}

