/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations.reflection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityListeners;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.TableGenerator;
import org.dom4j.Element;
import org.hibernate.annotations.common.reflection.AnnotationReader;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.java.JavaMetadataProvider;
import org.hibernate.cfg.annotations.reflection.JPAOverridenAnnotationReader;
import org.hibernate.cfg.annotations.reflection.XMLContext;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAMetadataProvider
implements MetadataProvider,
Serializable {
    private transient MetadataProvider delegate = new JavaMetadataProvider();
    private transient Map<Object, Object> defaults;
    private transient Map<AnnotatedElement, AnnotationReader> cache = new HashMap<AnnotatedElement, AnnotationReader>(100);
    private XMLContext xmlContext = new XMLContext();

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.delegate = new JavaMetadataProvider();
        this.cache = new HashMap<AnnotatedElement, AnnotationReader>(100);
    }

    public AnnotationReader getAnnotationReader(AnnotatedElement annotatedElement) {
        AnnotationReader reader = this.cache.get(annotatedElement);
        if (reader == null) {
            reader = this.xmlContext.hasContext() ? new JPAOverridenAnnotationReader(annotatedElement, this.xmlContext) : this.delegate.getAnnotationReader(annotatedElement);
            this.cache.put(annotatedElement, reader);
        }
        return reader;
    }

    public Map<Object, Object> getDefaults() {
        if (this.defaults == null) {
            this.defaults = new HashMap<Object, Object>();
            XMLContext.Default xmlDefaults = this.xmlContext.getDefault(null);
            this.defaults.put("delimited-identifier", xmlDefaults.getDelimitedIdentifier());
            ArrayList<Class> entityListeners = new ArrayList<Class>();
            for (String className : this.xmlContext.getDefaultEntityListeners()) {
                try {
                    entityListeners.add(ReflectHelper.classForName(className, this.getClass()));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Default entity listener class not found: " + className);
                }
            }
            this.defaults.put(EntityListeners.class, entityListeners);
            for (Element element : this.xmlContext.getAllDocuments()) {
                Object subelement2;
                List elements = element.elements("sequence-generator");
                ArrayList<SequenceGenerator> sequenceGenerators = (ArrayList<SequenceGenerator>)this.defaults.get(SequenceGenerator.class);
                if (sequenceGenerators == null) {
                    sequenceGenerators = new ArrayList<SequenceGenerator>();
                    this.defaults.put(SequenceGenerator.class, sequenceGenerators);
                }
                for (Object subelement2 : elements) {
                    sequenceGenerators.add(JPAOverridenAnnotationReader.buildSequenceGeneratorAnnotation((Element)subelement2));
                }
                elements = element.elements("table-generator");
                ArrayList<TableGenerator> tableGenerators = (ArrayList<TableGenerator>)this.defaults.get(TableGenerator.class);
                if (tableGenerators == null) {
                    tableGenerators = new ArrayList<TableGenerator>();
                    this.defaults.put(TableGenerator.class, tableGenerators);
                }
                subelement2 = elements.iterator();
                while (subelement2.hasNext()) {
                    Element subelement3 = (Element)subelement2.next();
                    tableGenerators.add(JPAOverridenAnnotationReader.buildTableGeneratorAnnotation(subelement3, xmlDefaults));
                }
                ArrayList namedQueries = (ArrayList)this.defaults.get(NamedQuery.class);
                if (namedQueries == null) {
                    namedQueries = new ArrayList();
                    this.defaults.put(NamedQuery.class, namedQueries);
                }
                List currentNamedQueries = JPAOverridenAnnotationReader.buildNamedQueries(element, false, xmlDefaults);
                namedQueries.addAll(currentNamedQueries);
                ArrayList namedNativeQueries = (ArrayList)this.defaults.get(NamedNativeQuery.class);
                if (namedNativeQueries == null) {
                    namedNativeQueries = new ArrayList();
                    this.defaults.put(NamedNativeQuery.class, namedNativeQueries);
                }
                List currentNamedNativeQueries = JPAOverridenAnnotationReader.buildNamedQueries(element, true, xmlDefaults);
                namedNativeQueries.addAll(currentNamedNativeQueries);
                ArrayList<SqlResultSetMapping> sqlResultSetMappings = (ArrayList<SqlResultSetMapping>)this.defaults.get(SqlResultSetMapping.class);
                if (sqlResultSetMappings == null) {
                    sqlResultSetMappings = new ArrayList<SqlResultSetMapping>();
                    this.defaults.put(SqlResultSetMapping.class, sqlResultSetMappings);
                }
                List<SqlResultSetMapping> currentSqlResultSetMappings = JPAOverridenAnnotationReader.buildSqlResultsetMappings(element, xmlDefaults);
                sqlResultSetMappings.addAll(currentSqlResultSetMappings);
            }
        }
        return this.defaults;
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }
}

