/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.collection.persistence.osgi;

import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.lookup.ServiceLookup;
import org.opennms.core.soa.lookup.ServiceLookupBuilder;
import org.opennms.core.soa.lookup.ServiceRegistryLookup;
import org.opennms.core.soa.support.DefaultServiceRegistry;
import org.opennms.features.collection.persistence.osgi.NullPersister;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiPersisterFactory
implements PersisterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiPersisterFactory.class);
    private final ServiceLookup<Class<?>, String> serviceLookup;

    public OsgiPersisterFactory() {
        this(false);
    }

    public OsgiPersisterFactory(boolean blocking) {
        this.serviceLookup = blocking ? new ServiceLookupBuilder((ServiceLookup)new ServiceRegistryLookup((ServiceRegistry)DefaultServiceRegistry.INSTANCE)).blocking().build() : new ServiceLookupBuilder((ServiceLookup)new ServiceRegistryLookup((ServiceRegistry)DefaultServiceRegistry.INSTANCE)).build();
    }

    public Persister createPersister(ServiceParameters params, RrdRepository repository) {
        PersisterFactory delegate = this.getDelegate();
        if (delegate == null) {
            LOG.info("Unable to find any persister factory from osgi registry, use NullPersister");
            return new NullPersister();
        }
        return delegate.createPersister(params, repository);
    }

    public Persister createPersister(ServiceParameters params, RrdRepository repository, boolean dontPersistCounters, boolean forceStoreByGroup, boolean dontReorderAttributes) {
        PersisterFactory delegate = this.getDelegate();
        if (delegate == null) {
            LOG.info("Unable to find any persister factory from osgi registry, use NullPersister");
            return new NullPersister();
        }
        return delegate.createPersister(params, repository, dontPersistCounters, forceStoreByGroup, dontReorderAttributes);
    }

    private PersisterFactory getDelegate() {
        return (PersisterFactory)this.serviceLookup.lookup(PersisterFactory.class, (Object)"(!(strategy=delegate))");
    }
}

