/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.services;

import java.util.Date;
import java.util.concurrent.ExecutorService;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.dao.api.EventConfEventDao;
import org.opennms.netmgt.dao.api.EventConfSourceDao;
import org.opennms.netmgt.dao.support.EventConfServiceHelper;
import org.opennms.netmgt.model.EventConfSource;
import org.opennms.netmgt.xml.eventconf.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class EventConfProgrammaticService {
    private static final Logger LOG = LoggerFactory.getLogger(EventConfProgrammaticService.class);
    private static final String PROGRAMMATIC_SOURCE_NAME = "opennms.programmatic.events";
    private static final String VENDOR = "opennms";
    private EventConfSourceDao eventConfSourceDao;
    private EventConfEventDao eventConfEventDao;
    private EventConfDao eventConfDao;
    private final ExecutorService eventConfExecutor = EventConfServiceHelper.createEventConfExecutor((String)"load-eventConf-programmatic-%d");

    @Transactional
    public void saveEventToDB(Event event, String username) {
        EventConfSource source = this.getOrCreateProgrammaticSource();
        EventConfServiceHelper.saveEvent((EventConfEventDao)this.eventConfEventDao, (EventConfSource)source, (Event)event, (String)username, (Date)new Date());
        source.setEventCount(Integer.valueOf(source.getEventCount() + 1));
        this.eventConfSourceDao.save((Object)source);
    }

    public void reloadEventsFromDB() {
        EventConfServiceHelper.reloadEventsFromDBAsync((EventConfEventDao)this.eventConfEventDao, (EventConfDao)this.eventConfDao, (ExecutorService)this.eventConfExecutor);
    }

    private EventConfSource getOrCreateProgrammaticSource() {
        EventConfSource source = this.eventConfSourceDao.findByName(PROGRAMMATIC_SOURCE_NAME);
        if (source == null) {
            LOG.info("Creating new programmatic event source: {}", (Object)PROGRAMMATIC_SOURCE_NAME);
            source = new EventConfSource();
            source.setName(PROGRAMMATIC_SOURCE_NAME);
            source.setVendor(VENDOR);
            source.setDescription("Programmatically generated events (e.g., from thresholds)");
            source.setEnabled(Boolean.valueOf(true));
            source.setEventCount(Integer.valueOf(0));
            source.setUploadedBy("system");
            Date now = new Date();
            source.setCreatedTime(now);
            source.setLastModified(now);
            Integer maxFileOrder = this.eventConfSourceDao.findMaxFileOrder();
            source.setFileOrder(Integer.valueOf(maxFileOrder != null ? maxFileOrder + 1 : 1));
            this.eventConfSourceDao.saveOrUpdate(source);
        }
        return source;
    }

    public void setEventConfSourceDao(EventConfSourceDao eventConfSourceDao) {
        this.eventConfSourceDao = eventConfSourceDao;
    }

    public void setEventConfEventDao(EventConfEventDao eventConfEventDao) {
        this.eventConfEventDao = eventConfEventDao;
    }

    public void setEventConfDao(EventConfDao eventConfDao) {
        this.eventConfDao = eventConfDao;
    }

    public void shutdown() {
        this.eventConfExecutor.shutdown();
    }
}

