/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.nodelabel;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.URLEncoder;
import java.sql.SQLException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.dao.api.NodeLabel;
import org.opennms.netmgt.dao.hibernate.NodeLabelDaoImpl;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.NodeLabelChangedEventBuilder;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.web.api.Util;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.servlet.MissingParameterException;
import org.opennms.web.svclayer.api.RequisitionAccessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class NodeLabelChangeServlet
extends HttpServlet {
    private static final long serialVersionUID = -7766362068448931124L;
    private static final Logger LOG = LoggerFactory.getLogger(NodeLabelChangeServlet.class);
    protected EventProxy proxy;

    public void init() throws ServletException {
        try {
            this.proxy = Util.createEventProxy();
        }
        catch (Throwable e) {
            throw new ServletException("JMS Exception", e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nodeIdString = request.getParameter("node");
        String labelType = request.getParameter("labeltype");
        String userLabel = request.getParameter("userlabel");
        if (nodeIdString == null) {
            throw new MissingParameterException("node", new String[]{"node", "labeltype", "userlabel"});
        }
        if (labelType == null) {
            throw new MissingParameterException("labeltype", new String[]{"node", "labeltype", "userlabel"});
        }
        if (userLabel == null) {
            throw new MissingParameterException("userlabel", new String[]{"node", "labeltype", "userlabel"});
        }
        try {
            TransactionTemplate transactionTemplate;
            boolean managedByProvisiond;
            final int nodeId = WebSecurityUtils.safeParseInt((String)nodeIdString);
            final OnmsNode node = NetworkElementFactory.getInstance(this.getServletContext()).getNode(nodeId);
            final NodeLabel nodeLabel = (NodeLabel)BeanUtils.getBean((String)"daoContext", (String)"nodeLabel", NodeLabel.class);
            NodeLabelDaoImpl oldLabel = new NodeLabelDaoImpl(node.getLabel(), node.getLabelSource());
            NodeLabel newLabel = null;
            if (labelType.equals("auto")) {
                newLabel = nodeLabel.computeLabel(nodeId);
            } else if (labelType.equals("user")) {
                newLabel = new NodeLabelDaoImpl(userLabel, OnmsNode.NodeLabelSource.USER);
            } else {
                throw new ServletException("Unexpected labeltype value: " + labelType);
            }
            final String newNodeLabel = newLabel.getLabel();
            boolean bl = managedByProvisiond = node.getForeignSource() != null && node.getForeignId() != null;
            if (managedByProvisiond) {
                WebApplicationContext beanFactory = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
                transactionTemplate = (TransactionTemplate)beanFactory.getBean(TransactionTemplate.class);
                final RequisitionAccessService requisitionService = (RequisitionAccessService)beanFactory.getBean(RequisitionAccessService.class);
                transactionTemplate.execute((TransactionCallback)new TransactionCallback<RequisitionNode>(){

                    public RequisitionNode doInTransaction(TransactionStatus status) {
                        MultivaluedHashMap params = new MultivaluedHashMap();
                        params.putSingle((Object)"node-label", (Object)newNodeLabel);
                        requisitionService.updateNode(node.getForeignSource(), node.getForeignId(), (MultivaluedMap)params);
                        return requisitionService.getNode(node.getForeignSource(), node.getForeignId());
                    }
                });
            }
            this.sendLabelChangeEvent(nodeId, (NodeLabel)oldLabel, newLabel);
            if (managedByProvisiond) {
                response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("admin/ng-requisitions/index.jsp#/requisitions/" + URLEncoder.encode(node.getForeignSource()) + "/nodes/" + URLEncoder.encode(node.getForeignId()))));
            } else {
                WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
                transactionTemplate = (TransactionTemplate)context.getBean(TransactionTemplate.class);
                final NodeLabel newLabelFinal = newLabel;
                transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        try {
                            nodeLabel.assignLabel(nodeId, newLabelFinal);
                        }
                        catch (SQLException e) {
                            LOG.error("Failed to change label on node with id: {} to: {}", new Object[]{nodeId, newLabelFinal, e});
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                });
                response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("element/node.jsp?node=" + nodeIdString)));
            }
        }
        catch (SQLException e) {
            throw new ServletException("Database exception", (Throwable)e);
        }
        catch (Throwable e) {
            throw new ServletException("Exception sending node label change event", e);
        }
    }

    protected void sendLabelChangeEvent(int nodeId, NodeLabel oldNodeLabel, NodeLabel newNodeLabel) throws EventProxyException {
        NodeLabelChangedEventBuilder bldr = new NodeLabelChangedEventBuilder("NodeLabelChangeServlet");
        bldr.setNodeid((long)nodeId);
        bldr.setHost("host");
        if (oldNodeLabel != null) {
            bldr.setOldNodeLabel(oldNodeLabel.getLabel());
            if (oldNodeLabel.getSource() != null) {
                bldr.setOldNodeLabelSource(oldNodeLabel.getSource().toString());
            }
        }
        if (newNodeLabel != null) {
            bldr.setNewNodeLabel(newNodeLabel.getLabel());
            if (newNodeLabel.getSource() != null) {
                bldr.setNewNodeLabelSource(newNodeLabel.getSource().toString());
            }
        }
        this.proxy.send(bldr.getEvent());
    }
}

