/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.model.AggregateStatusView;
import org.opennms.web.controller.SiteStatusViewError;
import org.opennms.web.svclayer.SiteStatusViewService;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class SiteStatusViewController
extends AbstractController {
    private static final int FIVE_MINUTES = 300;
    private static SiteStatusViewService m_service;

    public SiteStatusViewController() {
        this.setSupportedMethods(new String[]{"GET"});
        this.setCacheSeconds(300);
    }

    public void setService(SiteStatusViewService svc) {
        m_service = svc;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Collection aggrStati;
        ModelAndView mav = new ModelAndView("siteStatus");
        String statusView = req.getParameter("statusView");
        String statusSite = req.getParameter("statusSite");
        String nodeId = req.getParameter("nodeid");
        AggregateStatusView view = null;
        try {
            view = m_service.createAggregateStatusView(statusView);
        }
        catch (ObjectRetrievalFailureException e) {
            SiteStatusViewError viewError = this.createSiteStatusViewError((String)e.getIdentifier(), e.getMessage());
            return new ModelAndView("siteStatusError", "error", (Object)viewError);
        }
        if (nodeId != null && WebSecurityUtils.safeParseInt((String)nodeId) > 0) {
            aggrStati = m_service.createAggregateStatusesUsingNodeId(WebSecurityUtils.safeParseInt((String)nodeId), statusView);
        } else if (statusSite == null) {
            aggrStati = m_service.createAggregateStatuses(view);
        } else {
            aggrStati = m_service.createAggregateStatuses(view, statusSite);
            view.setColumnValue(statusSite);
        }
        mav.addObject("view", (Object)view);
        mav.addObject("stati", (Object)aggrStati);
        return mav;
    }

    private SiteStatusViewError createSiteStatusViewError(String shortDescr, String longDescr) {
        SiteStatusViewError viewError = new SiteStatusViewError();
        viewError.setShortDescr(shortDescr);
        viewError.setLongDescr(longDescr);
        return viewError;
    }
}

