/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.attrsummary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.attrsummary.Attribute;

@XmlRootElement(name="resource")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="attr-summary.xsd")
public class Resource
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="name", required=true)
    private String m_name;
    @XmlElement(name="attribute")
    private List<Attribute> m_attributes = new ArrayList<Attribute>();
    @XmlElement(name="resource")
    private List<Resource> m_resources = new ArrayList<Resource>();

    public Resource() {
    }

    public Resource(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public List<Attribute> getAttributes() {
        return this.m_attributes;
    }

    public void addAttribute(Attribute attribute) {
        this.m_attributes.add(attribute);
    }

    public void setAttributes(List<Attribute> attributes) {
        this.m_attributes.clear();
        this.m_attributes.addAll(attributes);
    }

    public List<Resource> getResources() {
        return this.m_resources;
    }

    public void addResource(Resource resource) {
        this.m_resources.add(resource);
    }

    public void setResources(List<Resource> resources) {
        this.m_resources.clear();
        this.m_resources.addAll(resources);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_attributes, this.m_resources);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.m_name, other.m_name) && Objects.equals(this.m_attributes, other.m_attributes) && Objects.equals(this.m_resources, other.m_resources);
    }
}

