/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.HashSet;
import java.util.Set;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.Util;

public class RrdJRobin14FileBackend
extends RrdBackend {
    private static final long LOCK_DELAY = 100L;
    private static Set<String> m_openFiles = new HashSet<String>();
    protected LockMode m_lockMode;
    protected RandomAccessFile m_file;
    protected FileLock m_fileLock;

    protected RrdJRobin14FileBackend(String path, boolean readOnly, LockMode lockMode) throws IOException {
        super(path, readOnly);
        this.m_lockMode = lockMode;
        this.m_file = new RandomAccessFile(path, readOnly ? "r" : "rw");
        try {
            this.lockFile();
            this.registerWriter();
        }
        catch (IOException ioe) {
            this.close();
            throw ioe;
        }
        System.err.println(String.format("backend initialized with path=%s, readOnly=%s, lockMode=%s", new Object[]{path, readOnly, lockMode}));
    }

    private void lockFile() throws IOException {
        switch (this.m_lockMode) {
            case EXCEPTION_IF_LOCKED: {
                this.m_fileLock = this.m_file.getChannel().tryLock();
                if (this.m_fileLock != null) break;
                throw new IOException("Access denied. File [" + this.getPath() + "] already locked");
            }
            case WAIT_IF_LOCKED: {
                while (this.m_fileLock == null) {
                    this.m_fileLock = this.m_file.getChannel().tryLock();
                    if (this.m_fileLock != null) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWriter() throws IOException {
        if (!this.isReadOnly()) {
            String canonicalPath = Util.getCanonicalPath(this.getPath());
            Set<String> set = m_openFiles;
            synchronized (set) {
                if (m_openFiles.contains(canonicalPath)) {
                    throw new IOException("File \"" + this.getPath() + "\" already open for R/W access. " + "You cannot open the same file for R/W access twice");
                }
                m_openFiles.add(canonicalPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.unregisterWriter();
        try {
            this.unlockFile();
        }
        finally {
            this.m_file.close();
        }
    }

    private void unlockFile() throws IOException {
        if (this.m_fileLock != null) {
            this.m_fileLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterWriter() throws IOException {
        if (!this.isReadOnly()) {
            Set<String> set = m_openFiles;
            synchronized (set) {
                m_openFiles.remove(Util.getCanonicalPath(this.getPath()));
            }
        }
    }

    public String getCanonicalPath() throws IOException {
        return Util.getCanonicalPath(this.getPath());
    }

    @Override
    protected void write(long offset, byte[] b) throws IOException {
        this.m_file.seek(offset);
        this.m_file.write(b);
    }

    @Override
    protected void read(long offset, byte[] b) throws IOException {
        this.m_file.seek(offset);
        if (this.m_file.read(b) != b.length) {
            throw new IOException("Not enough bytes available in file " + this.getPath());
        }
    }

    @Override
    public long getLength() throws IOException {
        return this.m_file.length();
    }

    @Override
    protected void setLength(long length) throws IOException {
        this.m_file.setLength(length);
    }

    public static enum LockMode {
        EXCEPTION_IF_LOCKED,
        WAIT_IF_LOCKED,
        NO_LOCKS;

    }
}

