/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.io.IOException;
import org.jrobin.cmd.ColonSplitter;
import org.jrobin.cmd.RrdToolCmd;
import org.jrobin.core.Datasource;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;

class RrdTuneCmd
extends RrdToolCmd {
    RrdTuneCmd() {
    }

    @Override
    String getCmdType() {
        return "tune";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object execute() throws RrdException, IOException {
        String[] heartbeats = this.getMultipleOptionValues("h", "heartbeat");
        String[] minimums = this.getMultipleOptionValues("i", "minimum");
        String[] maximums = this.getMultipleOptionValues("a", "maximum");
        String[] dsTypes = this.getMultipleOptionValues("d", "data-source-type");
        String[] dsNames = this.getMultipleOptionValues("r", "data-source-rename");
        String[] words = this.getRemainingWords();
        if (words.length < 2) {
            throw new RrdException("File name not specified");
        }
        if (words.length > 2) {
            throw new RrdException("Unexpected token encountered: " + words[2]);
        }
        String path = words[1];
        RrdDb rrd = RrdTuneCmd.getRrdDbReference(path);
        try {
            for (String heartbeat : heartbeats) {
                this.tuneHeartbeat(rrd, heartbeat);
            }
            for (String minimum : minimums) {
                this.tuneMinimum(rrd, minimum);
            }
            for (String maximum : maximums) {
                this.tuneMaximum(rrd, maximum);
            }
            for (String dsName : dsNames) {
                this.tuneName(rrd, dsName);
            }
            for (String dsType : dsTypes) {
                this.tuneType(rrd, dsType);
            }
            if (heartbeats.length == 0 && minimums.length == 0 && maximums.length == 0 && dsTypes.length == 0 && dsNames.length == 0) {
                this.dump(rrd);
            }
        }
        finally {
            RrdTuneCmd.releaseRrdDbReference(rrd);
        }
        return path;
    }

    private void tuneHeartbeat(RrdDb rrd, String heartbeatStr) throws RrdException, IOException {
        String[] tokens = new ColonSplitter(heartbeatStr).split();
        if (tokens.length != 2) {
            throw new RrdException("Invalid suntax in: " + heartbeatStr);
        }
        String dsName = tokens[0];
        long heartbeat = Long.parseLong(tokens[1]);
        Datasource ds = rrd.getDatasource(dsName);
        ds.setHeartbeat(heartbeat);
    }

    private void tuneMinimum(RrdDb rrd, String minimumStr) throws RrdException, IOException {
        String[] tokens = new ColonSplitter(minimumStr).split();
        if (tokens.length != 2) {
            throw new RrdException("Invalid suntax in: " + minimumStr);
        }
        String dsName = tokens[0];
        double minValue = Util.parseDouble(tokens[1]);
        Datasource ds = rrd.getDatasource(dsName);
        ds.setMinValue(minValue, false);
    }

    private void tuneMaximum(RrdDb rrd, String maximumStr) throws RrdException, IOException {
        String[] tokens = new ColonSplitter(maximumStr).split();
        if (tokens.length != 2) {
            throw new RrdException("Invalid suntax in: " + maximumStr);
        }
        String dsName = tokens[0];
        double maxValue = Util.parseDouble(tokens[1]);
        Datasource ds = rrd.getDatasource(dsName);
        ds.setMaxValue(maxValue, false);
    }

    private void tuneName(RrdDb rrd, String nameStr) throws RrdException, IOException {
        String[] tokens = new ColonSplitter(nameStr).split();
        if (tokens.length != 2) {
            throw new RrdException("Invalid suntax in: " + nameStr);
        }
        String oldName = tokens[0];
        String newName = tokens[1];
        Datasource ds = rrd.getDatasource(oldName);
        ds.setDsName(newName);
    }

    private void tuneType(RrdDb rrd, String typeStr) throws RrdException, IOException {
        String[] tokens = new ColonSplitter(typeStr).split();
        if (tokens.length != 2) {
            throw new RrdException("Invalid suntax in: " + typeStr);
        }
        String dsName = tokens[0];
        String dsType = tokens[1];
        Datasource ds = rrd.getDatasource(dsName);
        ds.setDsType(dsType);
    }

    private void dump(RrdDb rrd) throws IOException {
        StringBuffer line = new StringBuffer();
        int n = rrd.getDsCount();
        for (int i = 0; i < n; ++i) {
            Datasource ds = rrd.getDatasource(i);
            line.append("DS[");
            line.append(ds.getDsName());
            line.append("] typ: ");
            line.append(ds.getDsType());
            while (line.length() < 24) {
                line.append(' ');
            }
            line.append("hbt: ");
            line.append(ds.getHeartbeat());
            while (line.length() < 40) {
                line.append(' ');
            }
            line.append("min: ");
            line.append(String.format("%-11f", ds.getMinValue()));
            line.append("max: ");
            line.append(String.format("%-11f", ds.getMaxValue()));
            RrdTuneCmd.println(line.toString());
            line.setLength(0);
        }
    }
}

