/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.producer;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoOpProducer<K, V>
implements Producer<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(NoOpProducer.class);

    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.send(record, null);
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        LOG.debug("No-op producer: Not sending message to topic {}", (Object)record.topic());
        if (callback != null) {
            RecordMetadata dummyMetadata = new RecordMetadata(new TopicPartition(record.topic(), -1), -1L, -1L, System.currentTimeMillis(), Long.valueOf(-1L), -1, -1);
            callback.onCompletion(dummyMetadata, null);
        }
        CompletableFuture<RecordMetadata> future = new CompletableFuture<RecordMetadata>();
        RecordMetadata dummyMetadata = new RecordMetadata(new TopicPartition(record.topic(), -1), -1L, -1L, System.currentTimeMillis(), Long.valueOf(-1L), -1, -1);
        future.complete(dummyMetadata);
        return future;
    }

    public void flush() {
    }

    public void close() {
    }

    public void close(Duration duration) {
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return Collections.emptyMap();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return Collections.emptyList();
    }

    public void initTransactions() {
        throw new UnsupportedOperationException("No-op producer does not support transactions");
    }

    public void beginTransaction() {
        throw new UnsupportedOperationException("No-op producer does not support transactions");
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> map, String s) throws ProducerFencedException {
        throw new UnsupportedOperationException("No-op producer does not support transactions");
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> map, ConsumerGroupMetadata consumerGroupMetadata) throws ProducerFencedException {
        throw new UnsupportedOperationException("No-op producer does not support transactions");
    }

    public void commitTransaction() {
        throw new UnsupportedOperationException("No-op producer does not support transactions");
    }

    public void abortTransaction() {
        throw new UnsupportedOperationException("No-op producer does not support transactions");
    }
}

