/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.producer;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.features.kafka.producer.model.OpennmsModelProtos;

public class AlarmEqualityChecker {
    private final Function<OpennmsModelProtos.Alarm.Builder, OpennmsModelProtos.Alarm.Builder> applyExclusions;

    private AlarmEqualityChecker(Function<OpennmsModelProtos.Alarm.Builder, OpennmsModelProtos.Alarm.Builder> applyExclusions) {
        this.applyExclusions = Objects.requireNonNull(applyExclusions);
    }

    public static AlarmEqualityChecker with(Function<OpennmsModelProtos.Alarm.Builder, OpennmsModelProtos.Alarm.Builder> applyExclusions) {
        return new AlarmEqualityChecker(applyExclusions);
    }

    public boolean equalsExcludingOnBoth(OpennmsModelProtos.Alarm.Builder a, OpennmsModelProtos.Alarm.Builder b) {
        return this.applyExclusions.apply(Objects.requireNonNull(a)).build().equals(this.applyExclusions.apply(Objects.requireNonNull(b)).build());
    }

    public boolean equalsExcludingOnFirst(OpennmsModelProtos.Alarm.Builder a, OpennmsModelProtos.Alarm b) {
        return this.applyExclusions.apply(Objects.requireNonNull(a)).build().equals(Objects.requireNonNull(b));
    }

    public static class Exclusions {
        public static OpennmsModelProtos.Alarm.Builder defaultExclusions(OpennmsModelProtos.Alarm.Builder alarmBuilder) {
            if (!alarmBuilder.getRelatedAlarmList().isEmpty()) {
                List<OpennmsModelProtos.Alarm> relatedAlarmsWithExclusions = alarmBuilder.getRelatedAlarmList().stream().map(OpennmsModelProtos.Alarm::newBuilder).map(Exclusions::defaultExclusions).map(OpennmsModelProtos.Alarm.Builder::build).collect(Collectors.toList());
                alarmBuilder.clearRelatedAlarm();
                relatedAlarmsWithExclusions.forEach(alarmBuilder::addRelatedAlarm);
            }
            return alarmBuilder.clearCount().clearLastEvent().clearLastEventTime();
        }
    }
}

