/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tasks;

import org.opennms.core.tasks.AbstractTask;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.NeedsContainer;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.tasks.SequenceTask;

public class TaskBuilder<T extends ContainerTask<?>> {
    private T m_task;

    public TaskBuilder(T task) {
        this.m_task = task;
    }

    public TaskBuilder<SequenceTask> createSequence() {
        return ((AbstractTask)this.m_task).getCoordinator().createSequence((ContainerTask<?>)this.m_task);
    }

    public TaskBuilder<BatchTask> createBatch() {
        return ((AbstractTask)this.m_task).getCoordinator().createBatch((ContainerTask<?>)this.m_task);
    }

    public TaskBuilder<T> setParent(ContainerTask<?> parent) {
        parent.add((AbstractTask)this.m_task);
        return this;
    }

    public TaskBuilder<T> addSequence(Runnable ... runnables) {
        this.createSequence().add(runnables).setParent((ContainerTask<?>)this.m_task);
        return this;
    }

    public TaskBuilder<T> addSequence(RunInBatch ... runIns) {
        this.createSequence().add(runIns).setParent((ContainerTask<?>)this.m_task);
        return this;
    }

    public TaskBuilder<T> addBatch(Runnable ... runnables) {
        this.createBatch().add(runnables).setParent((ContainerTask<?>)this.m_task);
        return this;
    }

    public TaskBuilder<T> addBatch(RunInBatch ... runIns) {
        this.createBatch().add(runIns).setParent((ContainerTask<?>)this.m_task);
        return this;
    }

    public TaskBuilder<T> add(Runnable ... runnables) {
        for (Runnable r : runnables) {
            ((ContainerTask)this.m_task).add(r);
        }
        return this;
    }

    public TaskBuilder<T> add(RunInBatch ... runIns) {
        for (final RunInBatch runIn : runIns) {
            final TaskBuilder<BatchTask> bldr = this.createBatch();
            bldr.add(new Runnable(){

                @Override
                public void run() {
                    runIn.run((BatchTask)bldr.get());
                }
            }).setParent((ContainerTask<?>)this.m_task);
        }
        return this;
    }

    public TaskBuilder<T> add(NeedsContainer ... needers) {
        for (final NeedsContainer needer : needers) {
            this.add(new Runnable(){

                @Override
                public void run() {
                    needer.run((ContainerTask<?>)TaskBuilder.this.m_task);
                }
            });
        }
        return this;
    }

    public T get() {
        return this.m_task;
    }

    public T get(ContainerTask<?> parent) {
        return this.setParent(parent).get();
    }
}

