/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.rest.classification;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.flows.rest.classification.GroupDTO;

public class RuleDTO {
    private Integer id;
    private String name;
    private String dstAddress;
    private String dstPort;
    private String srcAddress;
    private String srcPort;
    private String exporterFilter;
    private boolean omnidirectional;
    private GroupDTO group;
    private Integer position;
    private List<String> protocols = new ArrayList<String>();

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDstAddress() {
        return this.dstAddress;
    }

    public void setDstAddress(String dstAddress) {
        this.dstAddress = dstAddress;
    }

    public String getDstPort() {
        return this.dstPort;
    }

    public void setDstPort(String dstPort) {
        this.dstPort = dstPort;
    }

    public String getSrcAddress() {
        return this.srcAddress;
    }

    public void setSrcAddress(String srcAddress) {
        this.srcAddress = srcAddress;
    }

    public String getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(String srcPort) {
        this.srcPort = srcPort;
    }

    public void setProtocol(String protocol) {
        if (protocol == null) {
            this.setProtocols(Lists.newArrayList());
        } else {
            this.setProtocols(Arrays.stream(protocol.split(",")).map(segment -> segment.trim()).filter(segment -> segment != null && segment.length() > 0).sorted().collect(Collectors.toList()));
        }
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<String> protocols) {
        this.protocols = protocols;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public Integer getPosition() {
        return this.position;
    }

    public String getExporterFilter() {
        return this.exporterFilter;
    }

    public void setExporterFilter(String exporterFilter) {
        this.exporterFilter = exporterFilter;
    }

    public boolean isOmnidirectional() {
        return this.omnidirectional;
    }

    public void setOmnidirectional(boolean omnidirectional) {
        this.omnidirectional = omnidirectional;
    }

    public void setGroup(GroupDTO group) {
        this.group = group;
    }

    public GroupDTO getGroup() {
        return this.group;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleDTO that = (RuleDTO)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.dstAddress, that.dstAddress) && Objects.equals(this.dstPort, that.dstPort) && Objects.equals(this.srcAddress, that.srcAddress) && Objects.equals(this.srcPort, that.srcPort) && Objects.equals(this.protocols, that.protocols) && Objects.equals(this.exporterFilter, that.exporterFilter) && Objects.equals(this.omnidirectional, that.omnidirectional) && Objects.equals(this.group, that.group) && Objects.equals(this.position, that.position);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.dstAddress, this.dstPort, this.srcAddress, this.srcPort, this.protocols, this.exporterFilter, this.omnidirectional, this.group, this.position);
    }
}

