/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.publisher.internal;

import com.eclipsesource.jaxrs.publisher.ResourceFilter;
import com.eclipsesource.jaxrs.publisher.internal.AllResourceFilter;
import com.eclipsesource.jaxrs.publisher.internal.ApplicationConfigurationTracker;
import com.eclipsesource.jaxrs.publisher.internal.Configuration;
import com.eclipsesource.jaxrs.publisher.internal.HttpServiceTracker;
import com.eclipsesource.jaxrs.publisher.internal.JAXRSConnector;
import com.eclipsesource.jaxrs.publisher.internal.ResourceTracker;
import com.eclipsesource.jaxrs.publisher.internal.ServletConfigurationTracker;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.ws.rs.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;

public class Activator
implements BundleActivator {
    private ServiceRegistration connectorRegistration;
    private JAXRSConnector jaxRsConnector;
    private HttpServiceTracker httpTracker;
    private ResourceTracker allTracker;
    private ServletConfigurationTracker servletConfigurationTracker;
    private ApplicationConfigurationTracker applicationConfigurationTracker;
    private ServiceRegistration configRegistration;

    public void start(BundleContext context) throws Exception {
        System.setProperty("javax.ws.rs.ext.RuntimeDelegate", "org.glassfish.jersey.server.internal.RuntimeDelegateImpl");
        this.startJerseyServer();
        this.jaxRsConnector = new JAXRSConnector(context);
        this.registerConfiguration(context);
        this.connectorRegistration = context.registerService(JAXRSConnector.class.getName(), (Object)this.jaxRsConnector, null);
        this.openHttpServiceTracker(context);
        this.openServletConfigurationTracker(context);
        this.openApplicationConfigurationTracker(context);
        this.openAllServiceTracker(context);
    }

    private void registerConfiguration(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.pid", "com.eclipsesource.jaxrs.connector");
        this.configRegistration = context.registerService(ManagedService.class.getName(), (Object)new Configuration(this.jaxRsConnector), properties);
    }

    private void startJerseyServer() throws BundleException {
        Bundle bundle = this.getJerseyAPIBundle();
        if (bundle.getState() != 32) {
            bundle.start();
        }
    }

    private void openHttpServiceTracker(BundleContext context) {
        this.httpTracker = new HttpServiceTracker(context, this.jaxRsConnector);
        this.httpTracker.open();
    }

    private void openServletConfigurationTracker(BundleContext context) {
        this.servletConfigurationTracker = new ServletConfigurationTracker(context, this.jaxRsConnector);
        this.servletConfigurationTracker.open();
    }

    private void openApplicationConfigurationTracker(BundleContext context) {
        this.applicationConfigurationTracker = new ApplicationConfigurationTracker(context, this.jaxRsConnector);
        this.applicationConfigurationTracker.open();
    }

    private void openAllServiceTracker(BundleContext context) throws InvalidSyntaxException {
        ResourceFilter allResourceFilter = this.getResourceFilter(context);
        this.allTracker = new ResourceTracker(context, allResourceFilter.getFilter(), this.jaxRsConnector);
        this.allTracker.open();
    }

    private ResourceFilter getResourceFilter(BundleContext context) {
        ServiceReference filterReference = context.getServiceReference(ResourceFilter.class.getName());
        if (filterReference != null) {
            return (ResourceFilter)context.getService(filterReference);
        }
        return new AllResourceFilter(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.httpTracker.close();
        this.servletConfigurationTracker.close();
        this.applicationConfigurationTracker.close();
        this.allTracker.close();
        this.connectorRegistration.unregister();
        this.configRegistration.unregister();
    }

    Bundle getJerseyAPIBundle() {
        return FrameworkUtil.getBundle(Path.class);
    }
}

