/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.wmi;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.core.utils.InetAddressUtils;

@XmlRootElement(name="wmi-agent-config")
@XmlAccessorType(value=XmlAccessType.NONE)
public class WmiAgentConfig {
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_RETRIES = 1;
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_USERNAME = "Administrator";
    public static final String DEFAULT_DOMAIN = "WORKGROUP";
    @XmlAttribute(name="address")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress m_Address;
    @XmlAttribute(name="timeout")
    private int m_Timeout;
    @XmlAttribute(name="retries")
    private int m_Retries;
    @XmlAttribute(name="username")
    private String m_Username;
    @XmlAttribute(name="domain")
    private String m_Domain;
    @XmlAttribute(name="password")
    private String m_Password;

    public WmiAgentConfig() {
        this.setDefaults();
    }

    public WmiAgentConfig(InetAddress agentAddress) {
        this.m_Address = agentAddress;
        this.setDefaults();
    }

    private void setDefaults() {
        this.m_Timeout = 3000;
        this.m_Retries = 1;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("AgentConfig[");
        buff.append("Address: " + String.valueOf(this.m_Address));
        buff.append(", Password: " + String.valueOf(this.m_Password));
        buff.append(", Timeout: " + this.m_Timeout);
        buff.append(", Retries: " + this.m_Retries);
        buff.append("]");
        return buff.toString();
    }

    public InetAddress getAddress() {
        return this.m_Address;
    }

    public void setAddress(InetAddress address) {
        this.m_Address = address;
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public void setTimeout(int timeout) {
        this.m_Timeout = timeout;
    }

    public int getRetries() {
        return this.m_Retries;
    }

    public void setRetries(int retries) {
        this.m_Retries = retries;
    }

    public void setPassword(String password) {
        this.m_Password = password;
    }

    public String getPassword() {
        return this.m_Password;
    }

    public String getUsername() {
        return this.m_Username;
    }

    public void setUsername(String username) {
        this.m_Username = username;
    }

    public String getDomain() {
        return this.m_Domain;
    }

    public void setDomain(String domain) {
        this.m_Domain = domain;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("address", InetAddressUtils.str((InetAddress)this.m_Address));
        map.put("domain", this.m_Domain);
        map.put("password", this.m_Password);
        map.put("retries", Integer.toString(this.m_Retries));
        map.put("timeout", Integer.toString(this.m_Timeout));
        map.put("username", this.m_Username);
        return map;
    }

    public static WmiAgentConfig fromMap(Map<String, String> map) {
        WmiAgentConfig agentConfig = new WmiAgentConfig();
        agentConfig.setAddress(InetAddressUtils.addr((String)map.get("address")));
        agentConfig.setDomain(map.get("domain"));
        agentConfig.setPassword(map.get("password"));
        agentConfig.setRetries(Integer.parseInt(map.get("retries")));
        agentConfig.setTimeout(Integer.parseInt(map.get("timeout")));
        agentConfig.setUsername(map.get("username"));
        return agentConfig;
    }

    public int hashCode() {
        return Objects.hash(this.m_Address, this.m_Domain, this.m_Password, this.m_Retries, this.m_Timeout, this.m_Username);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WmiAgentConfig other = (WmiAgentConfig)obj;
        return Objects.equals(this.m_Address, other.m_Address) && Objects.equals(this.m_Domain, other.m_Domain) && Objects.equals(this.m_Password, other.m_Password) && Objects.equals(this.m_Retries, other.m_Retries) && Objects.equals(this.m_Timeout, other.m_Timeout) && Objects.equals(this.m_Username, other.m_Username);
    }
}

