/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.syslogd;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="match")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="syslog.xsd")
public class Match
implements Serializable {
    private static final List<String> TYPE_OPTIONS = Arrays.asList("substr", "regex", "regexp");
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="type", required=true)
    private String m_type;
    @XmlAttribute(name="expression", required=true)
    private String m_expression;
    @XmlAttribute(name="default-parameter-mapping")
    private Boolean m_defaultParameterMapping;

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = ConfigUtils.assertOnlyContains(ConfigUtils.assertNotEmpty(type, "type"), TYPE_OPTIONS, "type");
    }

    public String getExpression() {
        return this.m_expression;
    }

    public void setExpression(String expression) {
        this.m_expression = ConfigUtils.assertNotEmpty(expression, "expression");
    }

    public Boolean getDefaultParameterMapping() {
        return this.m_defaultParameterMapping != null ? this.m_defaultParameterMapping : Boolean.TRUE;
    }

    public void setDefaultParameterMapping(Boolean defaultParameterMapping) {
        this.m_defaultParameterMapping = defaultParameterMapping;
    }

    public int hashCode() {
        return Objects.hash(this.m_type, this.m_expression, this.m_defaultParameterMapping);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Match) {
            Match that = (Match)obj;
            return Objects.equals(this.m_type, that.m_type) && Objects.equals(this.m_expression, that.m_expression) && Objects.equals(this.m_defaultParameterMapping, that.m_defaultParameterMapping);
        }
        return false;
    }
}

