/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmpinterfacepoller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.snmpinterfacepoller.CriticalService;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="node-outage")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="snmp-interface-poller-configuration.xsd")
public class NodeOutage
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="critical-service", required=true)
    private List<CriticalService> m_criticalServices = new ArrayList<CriticalService>();

    public List<CriticalService> getCriticalServices() {
        return this.m_criticalServices;
    }

    public void setCriticalServices(List<CriticalService> criticalServices) {
        ConfigUtils.assertMinimumSize(criticalServices, 1L, "critical-service");
        if (criticalServices == this.m_criticalServices) {
            return;
        }
        this.m_criticalServices.clear();
        if (criticalServices != null) {
            this.m_criticalServices.addAll(criticalServices);
        }
    }

    public void addCriticalService(CriticalService criticalService) {
        this.m_criticalServices.add(criticalService);
    }

    public boolean removeCriticalService(CriticalService criticalService) {
        return this.m_criticalServices.remove(criticalService);
    }

    public int hashCode() {
        return Objects.hash(this.m_criticalServices);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeOutage) {
            NodeOutage that = (NodeOutage)obj;
            return Objects.equals(this.m_criticalServices, that.m_criticalServices);
        }
        return false;
    }
}

