/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.mailtransporttest;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="sendmail-host")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="mail-transport-test.xsd")
public class SendmailHost
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="host")
    private String m_host;
    @XmlAttribute(name="port")
    private Long m_port;

    public SendmailHost() {
    }

    public SendmailHost(String host, Long port) {
        this.setHost(host);
        this.setPort(port);
    }

    public String getHost() {
        return this.m_host == null ? "${ipaddr}" : this.m_host;
    }

    public void setHost(String host) {
        this.m_host = ConfigUtils.normalizeString(host);
    }

    public Long getPort() {
        return this.m_port == null ? 25L : this.m_port;
    }

    public void setPort(Long port) {
        this.m_port = port;
    }

    public int hashCode() {
        return Objects.hash(this.m_host, this.m_port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SendmailHost) {
            SendmailHost that = (SendmailHost)obj;
            return Objects.equals(this.m_host, that.m_host) && Objects.equals(this.m_port, that.m_port);
        }
        return false;
    }
}

