/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.BridgeBridgeLink;
import org.opennms.netmgt.enlinkd.model.BridgeElement;
import org.opennms.netmgt.enlinkd.model.BridgeMacLink;
import org.opennms.netmgt.enlinkd.model.BridgeStpLink;
import org.opennms.netmgt.enlinkd.model.IpNetToMedia;
import org.opennms.netmgt.enlinkd.persistence.api.BridgeBridgeLinkDao;
import org.opennms.netmgt.enlinkd.persistence.api.BridgeElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.BridgeMacLinkDao;
import org.opennms.netmgt.enlinkd.persistence.api.BridgeStpLinkDao;
import org.opennms.netmgt.enlinkd.persistence.api.IpNetToMediaDao;
import org.opennms.netmgt.enlinkd.service.api.Bridge;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTableEntry;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.BroadcastDomain;
import org.opennms.netmgt.enlinkd.service.api.MacPort;
import org.opennms.netmgt.enlinkd.service.api.SharedSegment;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.enlinkd.service.api.TopologyShared;
import org.opennms.netmgt.enlinkd.service.impl.TopologyServiceImpl;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class BridgeTopologyServiceImpl
extends TopologyServiceImpl
implements BridgeTopologyService {
    private static final Logger LOG = LoggerFactory.getLogger(BridgeTopologyServiceImpl.class);
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private final Object lock = new Object();
    private BridgeElementDao m_bridgeElementDao;
    private BridgeBridgeLinkDao m_bridgeBridgeLinkDao;
    private BridgeMacLinkDao m_bridgeMacLinkDao;
    private BridgeStpLinkDao m_bridgeStpLinkDao;
    private IpNetToMediaDao m_ipNetToMediaDao;
    private final Map<Integer, Set<BridgeForwardingTableEntry>> m_nodetoBroadcastDomainMap = new HashMap<Integer, Set<BridgeForwardingTableEntry>>();
    private final Set<Integer> m_bridgecollectionsscheduled = new HashSet<Integer>();
    volatile Set<BroadcastDomain> m_domains;

    private MacPort acreate(IpNetToMedia media) {
        HashSet<InetAddress> ips = new HashSet<InetAddress>();
        ips.add(media.getNetAddress());
        MacPort port = new MacPort();
        port.setNodeId(media.getNodeId());
        port.setIfIndex(media.getIfIndex());
        port.setMacPortName(media.getPort());
        port.getMacPortMap().put(media.getPhysAddress(), ips);
        return port;
    }

    public String getBridgeDesignatedIdentifier(Bridge bridge) {
        for (BridgeElement element : this.m_bridgeElementDao.findByNodeId(bridge.getNodeId())) {
            String designated;
            if (!InetAddressUtils.isValidStpBridgeId((String)element.getStpDesignatedRoot()) || element.getBaseBridgeAddress().equals(InetAddressUtils.getBridgeAddressFromStpBridgeId((String)element.getStpDesignatedRoot())) || !InetAddressUtils.isValidBridgeAddress((String)(designated = InetAddressUtils.getBridgeAddressFromStpBridgeId((String)element.getStpDesignatedRoot())))) continue;
            return designated;
        }
        return null;
    }

    public Set<String> getBridgeIdentifiers(Bridge bridge) {
        HashSet<String> identifiers = new HashSet<String>();
        for (BridgeElement element : this.m_bridgeElementDao.findByNodeId(bridge.getNodeId())) {
            if (!InetAddressUtils.isValidBridgeAddress((String)element.getBaseBridgeAddress())) continue;
            identifiers.add(element.getBaseBridgeAddress());
        }
        return identifiers;
    }

    public BridgeElementDao getBridgeElementDao() {
        return this.m_bridgeElementDao;
    }

    public void setBridgeElementDao(BridgeElementDao bridgeElementDao) {
        this.m_bridgeElementDao = bridgeElementDao;
    }

    public BridgeBridgeLinkDao getBridgeBridgeLinkDao() {
        return this.m_bridgeBridgeLinkDao;
    }

    public void setBridgeBridgeLinkDao(BridgeBridgeLinkDao bridgeBridgeLinkDao) {
        this.m_bridgeBridgeLinkDao = bridgeBridgeLinkDao;
    }

    public BridgeMacLinkDao getBridgeMacLinkDao() {
        return this.m_bridgeMacLinkDao;
    }

    public void setBridgeMacLinkDao(BridgeMacLinkDao bridgeMacLinkDao) {
        this.m_bridgeMacLinkDao = bridgeMacLinkDao;
    }

    public void store(BroadcastDomain domain, Date now) {
        for (SharedSegment segment : domain.getSharedSegments()) {
            segment.getDesignatedPort();
        }
        for (SharedSegment segment : domain.getSharedSegments()) {
            for (BridgeBridgeLink link : segment.getBridgeBridgeLinks()) {
                link.setBridgeBridgeLinkLastPollTime(new Date());
                this.saveBridgeBridgeLink(link);
            }
            for (BridgeBridgeLink link : segment.getBridgeMacLinks()) {
                link.setBridgeMacLinkLastPollTime(new Date());
                this.saveBridgeMacLink((BridgeMacLink)link);
            }
        }
        domain.getForwarding().stream().filter(forward -> forward.getMacs().size() > 0).forEach(forward -> {
            for (BridgeMacLink link : forward.getBridgeMacLinks()) {
                link.setBridgeMacLinkLastPollTime(new Date());
                this.saveBridgeMacLink(link);
            }
        });
        for (Integer nodeid : domain.getBridgeNodesOnDomain()) {
            this.m_bridgeMacLinkDao.deleteByNodeIdOlderThen(nodeid, now);
            this.m_bridgeBridgeLinkDao.deleteByNodeIdOlderThen(nodeid, now);
            this.m_bridgeBridgeLinkDao.deleteByDesignatedNodeIdOlderThen(nodeid, now);
        }
        try {
            this.m_bridgeMacLinkDao.flush();
        }
        catch (Exception e) {
            LOG.error("BridgeMacLinkDao: {}", (Object)e.getMessage(), (Object)e);
        }
        try {
            this.m_bridgeBridgeLinkDao.flush();
        }
        catch (Exception e) {
            LOG.error("BridgeBridgeLinkDao: {}", (Object)e.getMessage(), (Object)e);
        }
        this.updatesAvailable();
    }

    @Transactional
    protected void saveBridgeMacLink(final BridgeMacLink saveMe) {
        new UpsertTemplate<BridgeMacLink, BridgeMacLinkDao>(this.m_transactionManager, this.m_bridgeMacLinkDao){

            protected BridgeMacLink query() {
                return ((BridgeMacLinkDao)this.m_dao).getByNodeIdBridgePortMac(saveMe.getNode().getId(), saveMe.getBridgePort(), saveMe.getMacAddress());
            }

            protected BridgeMacLink doUpdate(BridgeMacLink link) {
                link.merge(saveMe);
                ((BridgeMacLinkDao)this.m_dao).update((Object)link);
                ((BridgeMacLinkDao)this.m_dao).flush();
                return link;
            }

            protected BridgeMacLink doInsert() {
                if (saveMe.getBridgeMacLinkLastPollTime() == null) {
                    saveMe.setBridgeMacLinkLastPollTime(saveMe.getBridgeMacLinkCreateTime());
                }
                ((BridgeMacLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((BridgeMacLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Transactional
    protected void saveBridgeBridgeLink(final BridgeBridgeLink saveMe) {
        new UpsertTemplate<BridgeBridgeLink, BridgeBridgeLinkDao>(this.m_transactionManager, this.m_bridgeBridgeLinkDao){

            protected BridgeBridgeLink query() {
                return ((BridgeBridgeLinkDao)this.m_dao).getByNodeIdBridgePort(saveMe.getNode().getId(), saveMe.getBridgePort());
            }

            protected BridgeBridgeLink doUpdate(BridgeBridgeLink link) {
                link.merge(saveMe);
                ((BridgeBridgeLinkDao)this.m_dao).update((Object)link);
                ((BridgeBridgeLinkDao)this.m_dao).flush();
                return link;
            }

            protected BridgeBridgeLink doInsert() {
                if (saveMe.getBridgeBridgeLinkLastPollTime() == null) {
                    saveMe.setBridgeBridgeLinkLastPollTime(saveMe.getBridgeBridgeLinkCreateTime());
                }
                ((BridgeBridgeLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((BridgeBridgeLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object = this.lock;
        synchronized (object) {
            this.m_domains = this.getAllPersisted();
            for (BroadcastDomain domain : this.m_domains) {
                for (Bridge bridge : domain.getBridges()) {
                    bridge.clear();
                    bridge.getIdentifiers().addAll(this.getBridgeIdentifiers(bridge));
                    bridge.setDesignated(this.getBridgeDesignatedIdentifier(bridge));
                }
            }
        }
    }

    public void delete(int nodeid) {
        this.m_bridgeElementDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_bridgeElementDao.flush();
        this.m_bridgeStpLinkDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_bridgeStpLinkDao.flush();
        this.reconcile(this.getBroadcastDomain(nodeid), nodeid);
        this.m_bridgeBridgeLinkDao.deleteByDesignatedNodeId(Integer.valueOf(nodeid));
        this.m_bridgeBridgeLinkDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_bridgeBridgeLinkDao.flush();
        this.m_bridgeMacLinkDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_bridgeMacLinkDao.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BroadcastDomain getBroadcastDomain(int nodeId) {
        Object object = this.lock;
        synchronized (object) {
            for (BroadcastDomain domain : this.m_domains) {
                Bridge bridge = domain.getBridge(nodeId);
                if (bridge == null) continue;
                return domain;
            }
        }
        return null;
    }

    public BroadcastDomain reconcile(BroadcastDomain domain, int nodeId) {
        Date now = new Date();
        if (domain == null || domain.isEmpty()) {
            LOG.warn("reconcileTopologyForDeleteNode: node: {}, start: null domain or empty", (Object)nodeId);
            return domain;
        }
        if (domain.getBridge(nodeId) == null) {
            LOG.info("reconcileTopologyForDeleteNode: node: {}, not on domain", (Object)nodeId);
            return domain;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("reconcileTopologyForDeleteNode: node:[{}], domain:\n{}", (Object)nodeId, (Object)domain.printTopology());
        }
        LOG.info("reconcileTopologyForDeleteNode: node:[{}], start: save topology for domain", (Object)nodeId);
        domain.removeBridge(nodeId);
        this.store(domain, now);
        LOG.info("reconcileTopologyForDeleteNode: node:[{}], end: save topology for domain", (Object)nodeId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("reconcileTopologyForDeleteNode: node:[{}], resulting domain: {}", (Object)nodeId, (Object)domain.printTopology());
        }
        if (domain.getRootBridge() == null) {
            LOG.info("reconcileTopologyForDeleteNode: {}, domain without root", (Object)domain);
        }
        if (domain.isEmpty()) {
            this.cleanBroadcastDomains();
            LOG.info("reconcileTopologyForDeleteNode: node:[{}], empty domain", (Object)nodeId);
        }
        return domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanBroadcastDomains() {
        Object object = this.lock;
        synchronized (object) {
            this.m_domains.removeIf(BroadcastDomain::isEmpty);
        }
    }

    public synchronized void updateBridgeOnDomain(BroadcastDomain domain, Integer nodeId) {
        if (domain == null) {
            return;
        }
        for (Bridge bridge : domain.getBridges()) {
            if (bridge.getNodeId().intValue() != nodeId.intValue()) continue;
            bridge.clear();
            bridge.getIdentifiers().addAll(this.getBridgeIdentifiers(bridge));
            bridge.setDesignated(this.getBridgeDesignatedIdentifier(bridge));
            break;
        }
    }

    public void store(int nodeId, BridgeElement bridge) {
        if (bridge == null) {
            return;
        }
        this.saveBridgeElement(nodeId, bridge);
        this.updatesAvailable();
    }

    @Transactional
    protected void saveBridgeElement(final int nodeId, final BridgeElement saveMe) {
        new UpsertTemplate<BridgeElement, BridgeElementDao>(this.m_transactionManager, this.m_bridgeElementDao){

            protected BridgeElement query() {
                return ((BridgeElementDao)this.m_dao).getByNodeIdVlan(Integer.valueOf(nodeId), saveMe.getVlan());
            }

            protected BridgeElement doUpdate(BridgeElement bridge) {
                bridge.merge(saveMe);
                ((BridgeElementDao)this.m_dao).update((Object)bridge);
                ((BridgeElementDao)this.m_dao).flush();
                return bridge;
            }

            protected BridgeElement doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setBridgeNodeLastPollTime(saveMe.getBridgeNodeCreateTime());
                ((BridgeElementDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((BridgeElementDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    public void store(int nodeId, BridgeStpLink link) {
        if (link == null) {
            return;
        }
        this.saveBridgeStpLink(nodeId, link);
    }

    @Transactional
    protected void saveBridgeStpLink(final int nodeId, final BridgeStpLink saveMe) {
        new UpsertTemplate<BridgeStpLink, BridgeStpLinkDao>(this.m_transactionManager, this.m_bridgeStpLinkDao){

            protected BridgeStpLink query() {
                return ((BridgeStpLinkDao)this.m_dao).getByNodeIdBridgePort(Integer.valueOf(nodeId), saveMe.getStpPort());
            }

            protected BridgeStpLink doUpdate(BridgeStpLink link) {
                link.merge(saveMe);
                ((BridgeStpLinkDao)this.m_dao).update((Object)link);
                ((BridgeStpLinkDao)this.m_dao).flush();
                return link;
            }

            protected BridgeStpLink doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setBridgeStpLinkLastPollTime(saveMe.getBridgeStpLinkCreateTime());
                ((BridgeStpLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((BridgeStpLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(int nodeId, List<BridgeForwardingTableEntry> bft) {
        HashSet<BridgeForwardingTableEntry> effectiveBFT = new HashSet<BridgeForwardingTableEntry>();
        for (BridgeForwardingTableEntry link : bft) {
            link.setNodeId(Integer.valueOf(nodeId));
            effectiveBFT.add(link);
        }
        Map<Integer, Set<BridgeForwardingTableEntry>> map = this.m_nodetoBroadcastDomainMap;
        synchronized (map) {
            this.m_nodetoBroadcastDomainMap.put(nodeId, effectiveBFT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Set<BridgeForwardingTableEntry>> getUpdateBftMap() {
        Map<Integer, Set<BridgeForwardingTableEntry>> map = this.m_nodetoBroadcastDomainMap;
        synchronized (map) {
            return this.m_nodetoBroadcastDomainMap;
        }
    }

    public void reconcile(int nodeId, Date now) {
        this.m_bridgeElementDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_bridgeElementDao.flush();
        this.m_bridgeStpLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_bridgeStpLinkDao.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BroadcastDomain> findAll() {
        Object object = this.lock;
        synchronized (object) {
            return this.m_domains;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BroadcastDomain domain) {
        Object object = this.lock;
        synchronized (object) {
            this.m_domains.add(domain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BridgeForwardingTableEntry> useBridgeTopologyUpdateBFT(int nodeid) {
        Map<Integer, Set<BridgeForwardingTableEntry>> map = this.m_nodetoBroadcastDomainMap;
        synchronized (map) {
            return this.m_nodetoBroadcastDomainMap.remove(nodeid);
        }
    }

    public List<SharedSegment> getSharedSegments(int nodeid) {
        ArrayList<SharedSegment> segments = new ArrayList<SharedSegment>();
        block0: for (BridgeBridgeLink link : this.m_bridgeBridgeLinkDao.findByDesignatedNodeId(Integer.valueOf(nodeid))) {
            for (SharedSegment segment : segments) {
                if (!segment.containsPort(BridgeTopologyService.getBridgePortFromDesignatedBridgeBridgeLink((BridgeBridgeLink)link))) continue;
                segment.getBridgePortsOnSegment().add(BridgeTopologyService.getBridgePortFromBridgeBridgeLink((BridgeBridgeLink)link));
                continue block0;
            }
            segments.add(BridgeTopologyService.createSharedSegmentFromBridgeBridgeLink((BridgeBridgeLink)link));
        }
        HashSet<BridgePort> designated = new HashSet<BridgePort>();
        for (BridgeBridgeLink link : this.m_bridgeBridgeLinkDao.findByNodeId(Integer.valueOf(nodeid))) {
            designated.add(BridgeTopologyService.getBridgePortFromDesignatedBridgeBridgeLink((BridgeBridgeLink)link));
        }
        for (BridgePort designatedport : designated) {
            block4: for (BridgeBridgeLink link : this.m_bridgeBridgeLinkDao.getByDesignatedNodeIdBridgePort(designatedport.getNodeId(), designatedport.getBridgePort())) {
                for (SharedSegment segment : segments) {
                    if (!segment.containsPort(BridgeTopologyService.getBridgePortFromDesignatedBridgeBridgeLink((BridgeBridgeLink)link))) continue;
                    segment.getBridgePortsOnSegment().add(BridgeTopologyService.getBridgePortFromBridgeBridgeLink((BridgeBridgeLink)link));
                    continue block4;
                }
                segments.add(BridgeTopologyService.createSharedSegmentFromBridgeBridgeLink((BridgeBridgeLink)link));
            }
        }
        block6: for (BridgeBridgeLink link : this.m_bridgeMacLinkDao.findByNodeId(Integer.valueOf(nodeid))) {
            if (link.getLinkType() == BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER) continue;
            for (SharedSegment segment : segments) {
                if (!segment.containsPort(BridgeTopologyService.getBridgePortFromBridgeMacLink((BridgeMacLink)link))) continue;
                segment.getMacsOnSegment().add(link.getMacAddress());
                continue block6;
            }
            segments.add(BridgeTopologyService.createSharedSegmentFromBridgeMacLink((BridgeMacLink)link));
        }
        return segments;
    }

    public SharedSegment getSharedSegment(String mac) {
        LOG.debug("getHostNodeSharedSegment: founding segment for mac:{}", (Object)mac);
        List links = this.m_bridgeMacLinkDao.findByMacAddress(mac).stream().filter(maclink -> maclink.getLinkType() == BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK).collect(Collectors.toCollection(ArrayList::new));
        if (links.size() == 0) {
            LOG.info("getHostNodeSharedSegment: no segment found for mac:{}", (Object)mac);
            return new SharedSegment();
        }
        if (links.size() > 1) {
            LOG.error("getHostNodeSharedSegment: more then one segment for mac:{}", (Object)mac);
            return new SharedSegment();
        }
        BridgeMacLink link = (BridgeMacLink)links.iterator().next();
        SharedSegment segment = null;
        try {
            for (BridgeBridgeLink bblink : this.m_bridgeBridgeLinkDao.getByDesignatedNodeIdBridgePort(link.getNode().getId(), link.getBridgePort())) {
                if (segment == null) {
                    segment = BridgeTopologyService.createSharedSegmentFromBridgeBridgeLink((BridgeBridgeLink)bblink);
                    continue;
                }
                segment.getBridgePortsOnSegment().add(BridgeTopologyService.getBridgePortFromBridgeBridgeLink((BridgeBridgeLink)bblink));
            }
            for (BridgeMacLink maclink2 : this.m_bridgeMacLinkDao.findByNodeIdBridgePort(link.getNode().getId(), link.getBridgePort())) {
                if (segment == null) {
                    segment = BridgeTopologyService.createSharedSegmentFromBridgeMacLink((BridgeMacLink)maclink2);
                    continue;
                }
                segment.getMacsOnSegment().add(maclink2.getMacAddress());
            }
        }
        catch (Exception e) {
            LOG.error("getHostNodeSharedSegment: cannot create shared segment {} for mac {} ", new Object[]{e.getMessage(), mac, e});
            return new SharedSegment();
        }
        return segment;
    }

    public Set<BroadcastDomain> getAllPersisted() {
        Bridge bridge;
        Object domain;
        CopyOnWriteArraySet<BroadcastDomain> domains = new CopyOnWriteArraySet<BroadcastDomain>();
        ArrayList<SharedSegment> bblsegments = new ArrayList<SharedSegment>();
        HashMap<Integer, Set> rootnodetodomainnodemap = new HashMap<Integer, Set>();
        HashMap<Integer, BridgePort> designatebridgemap = new HashMap<Integer, BridgePort>();
        for (BridgeBridgeLink link : this.m_bridgeBridgeLinkDao.findAll()) {
            boolean segmentnotfound = true;
            BridgePort bridgeport = BridgeTopologyService.getBridgePortFromBridgeBridgeLink((BridgeBridgeLink)link);
            designatebridgemap.put(link.getNode().getId(), bridgeport);
            for (SharedSegment bblsegment : bblsegments) {
                if (!bblsegment.containsPort(BridgeTopologyService.getBridgePortFromDesignatedBridgeBridgeLink((BridgeBridgeLink)link))) continue;
                bblsegment.getBridgePortsOnSegment().add(bridgeport);
                segmentnotfound = false;
                break;
            }
            if (segmentnotfound) {
                bblsegments.add(BridgeTopologyService.createSharedSegmentFromBridgeBridgeLink((BridgeBridgeLink)link));
            }
            if (rootnodetodomainnodemap.containsKey(link.getDesignatedNode().getId())) {
                ((Set)rootnodetodomainnodemap.get(link.getDesignatedNode().getId())).add(link.getNode().getId());
                if (!rootnodetodomainnodemap.containsKey(link.getNode().getId())) continue;
                ((Set)rootnodetodomainnodemap.get(link.getDesignatedNode().getId())).addAll((Collection)rootnodetodomainnodemap.remove(link.getNode().getId()));
                continue;
            }
            if (rootnodetodomainnodemap.containsKey(link.getNode().getId())) {
                Set dependentsnode = (Set)rootnodetodomainnodemap.remove(link.getNode().getId());
                dependentsnode.add(link.getNode().getId());
                Object rootdesignated = null;
                for (Integer rootid : rootnodetodomainnodemap.keySet()) {
                    if (!((Set)rootnodetodomainnodemap.get(rootid)).contains(link.getDesignatedNode().getId())) continue;
                    rootdesignated = rootid;
                    break;
                }
                if (rootdesignated != null) {
                    dependentsnode.add(link.getDesignatedNode().getId());
                    ((Set)rootnodetodomainnodemap.get(rootdesignated)).addAll(dependentsnode);
                    continue;
                }
                rootnodetodomainnodemap.put(link.getDesignatedNode().getId(), dependentsnode);
                continue;
            }
            Object rootdesignated = null;
            for (Object rootid : rootnodetodomainnodemap.keySet()) {
                if (!((Set)rootnodetodomainnodemap.get(rootid)).contains(link.getDesignatedNode().getId())) continue;
                rootdesignated = rootid;
                break;
            }
            if (rootdesignated != null) {
                ((Set)rootnodetodomainnodemap.get(rootdesignated)).add(link.getNode().getId());
                continue;
            }
            rootnodetodomainnodemap.put(link.getDesignatedNode().getId(), new HashSet());
            ((Set)rootnodetodomainnodemap.get(link.getDesignatedNode().getId())).add(link.getNode().getId());
        }
        LOG.info("getAllPersisted: bridge topology node set: {}", rootnodetodomainnodemap);
        ArrayList<SharedSegment> bmlsegments = new ArrayList<SharedSegment>();
        ArrayList<BridgeMacLink> forwarders = new ArrayList<BridgeMacLink>();
        block4: for (BridgeMacLink link : this.m_bridgeMacLinkDao.findAll()) {
            if (link.getLinkType() == BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER) {
                forwarders.add(link);
                continue;
            }
            for (SharedSegment bblsegment : bblsegments) {
                if (!bblsegment.containsPort(BridgeTopologyService.getBridgePortFromBridgeMacLink((BridgeMacLink)link))) continue;
                bblsegment.getMacsOnSegment().add(link.getMacAddress());
                continue block4;
            }
            for (SharedSegment bmlsegment : bmlsegments) {
                if (!bmlsegment.containsPort(BridgeTopologyService.getBridgePortFromBridgeMacLink((BridgeMacLink)link))) continue;
                bmlsegment.getMacsOnSegment().add(link.getMacAddress());
                continue block4;
            }
            bmlsegments.add(BridgeTopologyService.createSharedSegmentFromBridgeMacLink((BridgeMacLink)link));
        }
        for (Integer rootNodeid : rootnodetodomainnodemap.keySet()) {
            domain = new BroadcastDomain();
            bridge = new Bridge(rootNodeid);
            bridge.setRootBridge();
            domain.getBridges().add(bridge);
            for (Integer nodeid : (Set)rootnodetodomainnodemap.get(rootNodeid)) {
                Bridge newbridge = new Bridge(nodeid);
                newbridge.setRootPort(((BridgePort)designatebridgemap.get(nodeid)).getBridgePort());
                domain.getBridges().add(newbridge);
            }
            domains.add((BroadcastDomain)domain);
        }
        for (SharedSegment segment : bblsegments) {
            BroadcastDomain cdomain;
            domain = domains.iterator();
            while (domain.hasNext() && !(cdomain = (BroadcastDomain)domain.next()).loadTopologyEntry(segment)) {
            }
        }
        block11: for (SharedSegment segment : bmlsegments) {
            for (BroadcastDomain cdomain : domains) {
                if (!cdomain.loadTopologyEntry(segment)) continue;
                continue block11;
            }
            domain = new BroadcastDomain();
            bridge = new Bridge(segment.getDesignatedBridge());
            bridge.setRootBridge();
            domain.getBridges().add(bridge);
            domain.loadTopologyEntry(segment);
            domains.add((BroadcastDomain)domain);
        }
        block13: for (BridgeMacLink forwarder : forwarders) {
            for (BroadcastDomain domain2 : domains) {
                Bridge bridge2 = domain2.getBridge(forwarder.getNode().getId().intValue());
                if (bridge2 == null) continue;
                domain2.addForwarding(BridgeTopologyService.getBridgePortFromBridgeMacLink((BridgeMacLink)forwarder), forwarder.getMacAddress());
                continue block13;
            }
        }
        return domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collectBft(int nodeid, int maxsize) {
        Set<Integer> set = this.m_bridgecollectionsscheduled;
        synchronized (set) {
            if (this.getUpdateBftMap().size() + this.m_bridgecollectionsscheduled.size() >= maxsize) {
                return false;
            }
            Set<Integer> set2 = this.m_bridgecollectionsscheduled;
            synchronized (set2) {
                this.m_bridgecollectionsscheduled.add(nodeid);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectedBft(int nodeid) {
        Set<Integer> set = this.m_bridgecollectionsscheduled;
        synchronized (set) {
            this.m_bridgecollectionsscheduled.remove(nodeid);
        }
    }

    public BridgeStpLinkDao getBridgeStpLinkDao() {
        return this.m_bridgeStpLinkDao;
    }

    public void setBridgeStpLinkDao(BridgeStpLinkDao bridgeStpLinkDao) {
        this.m_bridgeStpLinkDao = bridgeStpLinkDao;
    }

    public List<MacPort> getMacPorts() {
        HashMap macToMacPortMap = new HashMap();
        HashBasedTable nodeIfindexToMacPortTable = HashBasedTable.create();
        this.m_ipNetToMediaDao.findAll().forEach(arg_0 -> BridgeTopologyServiceImpl.lambda$getMacPorts$3((Table)nodeIfindexToMacPortTable, macToMacPortMap, arg_0));
        ArrayList<MacPort> ports = new ArrayList<MacPort>(nodeIfindexToMacPortTable.values());
        ports.forEach(mp -> mp.getMacPortMap().keySet().stream().filter(macToMacPortMap::containsKey).forEach(mac -> ((Set)mp.getMacPortMap().get(mac)).addAll((Collection)((MacPort)macToMacPortMap.remove(mac)).getMacPortMap().get(mac))));
        ports.addAll(macToMacPortMap.values());
        return ports;
    }

    public void deletePersistedData() {
        this.m_bridgeElementDao.deleteAll();
        this.m_bridgeElementDao.flush();
        this.m_bridgeMacLinkDao.deleteAll();
        this.m_bridgeMacLinkDao.flush();
        this.m_bridgeBridgeLinkDao.deleteAll();
        this.m_bridgeBridgeLinkDao.flush();
        this.m_bridgeStpLinkDao.deleteAll();
        this.m_bridgeStpLinkDao.flush();
        this.m_ipNetToMediaDao.deleteAll();
        this.m_ipNetToMediaDao.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopologyShared> match() {
        ArrayList<TopologyShared> links = new ArrayList<TopologyShared>();
        List<MacPort> macPortMap = this.getMacPorts();
        Object object = this.lock;
        synchronized (object) {
            this.m_domains.forEach(dm -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("match: \n{}", (Object)dm.printTopology());
                }
                dm.getSharedSegments().forEach(shs -> links.add(TopologyService.of((SharedSegment)shs, macPortMap.stream().filter(mp -> shs.getMacsOnSegment().containsAll(mp.getMacPortMap().keySet())).collect(Collectors.toList()))));
            });
        }
        return links;
    }

    public IpNetToMediaDao getIpNetToMediaDao() {
        return this.m_ipNetToMediaDao;
    }

    public void setIpNetToMediaDao(IpNetToMediaDao ipNetToMediaDao) {
        this.m_ipNetToMediaDao = ipNetToMediaDao;
    }

    private static /* synthetic */ void lambda$getMacPorts$3(Table nodeIfindexToMacPortTable, Map macToMacPortMap, IpNetToMedia m) {
        boolean merge = false;
        MacPort macport = new MacPort();
        HashSet<InetAddress> ips = new HashSet<InetAddress>();
        ips.add(m.getNetAddress());
        macport.setNodeId(m.getNodeId());
        macport.setIfIndex(m.getIfIndex());
        macport.setMacPortName(m.getPort());
        macport.getMacPortMap().put(m.getPhysAddress(), ips);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getMacPorts: parsing: {}", (Object)m);
        }
        if (m.getNode() != null) {
            if (nodeIfindexToMacPortTable.contains((Object)m.getNode().getId(), (Object)m.getIfIndex())) {
                macport = (MacPort)nodeIfindexToMacPortTable.get((Object)m.getNode().getId(), (Object)m.getIfIndex());
                merge = true;
            } else {
                nodeIfindexToMacPortTable.put((Object)m.getNode().getId(), (Object)m.getIfIndex(), (Object)macport);
            }
        } else if (macToMacPortMap.containsKey(m.getPhysAddress())) {
            macport = (MacPort)macToMacPortMap.get(m.getPhysAddress());
            merge = true;
        } else {
            macToMacPortMap.put(m.getPhysAddress(), macport);
        }
        if (merge) {
            if (!macport.getMacPortMap().containsKey(m.getPhysAddress())) {
                macport.getMacPortMap().put(m.getPhysAddress(), new HashSet());
            }
            ((Set)macport.getMacPortMap().get(m.getPhysAddress())).add(m.getNetAddress());
        }
    }
}

