/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.dao;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsNode;

public class NodeDaoImpl
implements org.opennms.integration.api.v1.dao.NodeDao {
    private final NodeDao nodeDao;
    private final SessionUtils sessionUtils;

    public NodeDaoImpl(NodeDao nodeDao, SessionUtils sessionUtils) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
    }

    public String getDefaultLocationName() {
        return "Default";
    }

    public List<Node> getNodes() {
        return (List)this.sessionUtils.withReadOnlyTransaction(() -> this.nodeDao.findAll().stream().map(ModelMappers::toNode).collect(Collectors.toList()));
    }

    public Long getNodeCount() {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsNode.class);
        return (Long)this.sessionUtils.withReadOnlyTransaction(() -> this.nodeDao.countMatching(criteriaBuilder.toCriteria()));
    }

    public List<Integer> getNodeIds() {
        return (List)this.sessionUtils.withReadOnlyTransaction(() -> Lists.newArrayList((Iterable)this.nodeDao.getNodeIds()));
    }

    public Node getNodeByCriteria(String nodeCriteria) {
        return (Node)this.sessionUtils.withReadOnlyTransaction(() -> ModelMappers.toNode(this.nodeDao.get(nodeCriteria)));
    }

    public Node getNodeById(Integer nodeId) {
        return (Node)this.sessionUtils.withReadOnlyTransaction(() -> ModelMappers.toNode((OnmsNode)this.nodeDao.get((Serializable)nodeId)));
    }

    public Node getNodeByLabel(String nodeLabel) {
        return (Node)this.sessionUtils.withReadOnlyTransaction(() -> ModelMappers.toNode(this.nodeDao.findByLabel(nodeLabel).stream().min(Comparator.comparingInt(OnmsNode::getId)).orElse(null)));
    }

    public Node getNodeByForeignSourceAndForeignId(String foreignSource, String foreignId) {
        return (Node)this.sessionUtils.withReadOnlyTransaction(() -> ModelMappers.toNode(this.nodeDao.findByForeignId(foreignSource, foreignId)));
    }

    public List<Node> getNodesInLocation(String locationName) {
        Criteria criteria = new CriteriaBuilder(OnmsNode.class).alias("location", "location", Alias.JoinType.LEFT_JOIN).eq("location.id", (Object)locationName).toCriteria();
        return this.getNodesMatching(criteria);
    }

    public List<Node> getNodesInForeignSource(String foreignSource) {
        Criteria criteria = new CriteriaBuilder(OnmsNode.class).eq("foreignSource", (Object)foreignSource).toCriteria();
        return this.getNodesMatching(criteria);
    }

    private List<Node> getNodesMatching(Criteria criteria) {
        return (List)this.sessionUtils.withReadOnlyTransaction(() -> this.nodeDao.findMatching(criteria).stream().map(ModelMappers::toNode).collect(Collectors.toList()));
    }
}

