/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.netmgt.alarmd.api.AlarmLifecycleListener;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AlarmEntityListener;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsMemo;
import org.opennms.netmgt.model.OnmsReductionKeyMemo;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.TroubleTicketState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class AlarmLifecycleListenerManager
implements AlarmEntityListener,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmLifecycleListenerManager.class);
    public static final String ALARM_SNAPSHOT_INTERVAL_MS_SYS_PROP = "org.opennms.alarms.snapshot.sync.ms";
    public static final long ALARM_SNAPSHOT_INTERVAL_MS = SystemProperties.getLong((String)"org.opennms.alarms.snapshot.sync.ms", (Long)TimeUnit.MINUTES.toMillis(2L));
    private final Set<AlarmLifecycleListener> listeners = Sets.newConcurrentHashSet();
    private Timer timer;
    @Autowired
    private AlarmDao alarmDao;
    @Autowired
    private SessionUtils sessionUtils;

    private void start() {
        this.timer = new Timer("AlarmLifecycleListenerManager");
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    AlarmLifecycleListenerManager.this.doSnapshot();
                }
                catch (Exception e) {
                    LOG.error("Error while performing snapshot update.", (Throwable)e);
                }
            }
        }, 0L, ALARM_SNAPSHOT_INTERVAL_MS);
    }

    private void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSnapshot() {
        if (this.listeners.size() < 1) {
            return;
        }
        AtomicLong numAlarms = new AtomicLong(-1L);
        long systemMillisBeforeSnapshot = System.currentTimeMillis();
        AtomicLong systemMillisAfterLoad = new AtomicLong(-1L);
        try {
            this.forEachListener(AlarmLifecycleListener::preHandleAlarmSnapshot);
            this.sessionUtils.withTransaction(() -> {
                List allAlarms = this.alarmDao.findAll();
                numAlarms.set(allAlarms.size());
                systemMillisAfterLoad.set(System.currentTimeMillis());
                this.forEachListener(l -> {
                    LOG.debug("Calling handleAlarmSnapshot on listener: {}", l);
                    l.handleAlarmSnapshot(allAlarms);
                    LOG.debug("Done calling listener.");
                });
                return null;
            });
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                long now = System.currentTimeMillis();
                LOG.debug("Alarm snapshot for {} alarms completed. Spent {}ms loading the alarms. Snapshot processing took a total of of {}ms.", new Object[]{numAlarms.get(), systemMillisAfterLoad.get() - systemMillisBeforeSnapshot, now - systemMillisBeforeSnapshot});
            }
            this.forEachListener(AlarmLifecycleListener::postHandleAlarmSnapshot);
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            long now = System.currentTimeMillis();
            LOG.debug("Alarm snapshot for {} alarms completed. Spent {}ms loading the alarms. Snapshot processing took a total of of {}ms.", new Object[]{numAlarms.get(), systemMillisAfterLoad.get() - systemMillisBeforeSnapshot, now - systemMillisBeforeSnapshot});
        }
        this.forEachListener(AlarmLifecycleListener::postHandleAlarmSnapshot);
    }

    public void onNewOrUpdatedAlarm(OnmsAlarm alarm) {
        this.forEachListener(l -> l.handleNewOrUpdatedAlarm(alarm));
    }

    public void onAlarmArchived(OnmsAlarm alarm, String previousReductionKey) {
        this.onNewOrUpdatedAlarm(alarm);
    }

    public void onAlarmDeleted(OnmsAlarm alarm) {
        this.forEachListener(l -> l.handleDeletedAlarm(alarm.getId().intValue(), alarm.getReductionKey()));
    }

    public void onAlarmCreated(OnmsAlarm alarm) {
        this.onNewOrUpdatedAlarm(alarm);
    }

    public void onAlarmUpdatedWithReducedEvent(OnmsAlarm alarm) {
        this.onNewOrUpdatedAlarm(alarm);
    }

    public void onAlarmAcknowledged(OnmsAlarm alarm, String previousAckUser, Date previousAckTime) {
        this.onNewOrUpdatedAlarm(alarm);
    }

    public void onAlarmUnacknowledged(OnmsAlarm alarm, String previousAckUser, Date previousAckTime) {
        this.onNewOrUpdatedAlarm(alarm);
    }

    public void onAlarmSeverityUpdated(OnmsAlarm alarm, OnmsSeverity previousSeverity) {
        this.onNewOrUpdatedAlarm(alarm);
    }

    public void onStickyMemoUpdated(OnmsAlarm alarm, String previousBody, String previousAuthor, Date previousUpdated) {
        this.onNewOrUpdatedAlarm(alarm);
    }

    public void onReductionKeyMemoUpdated(OnmsAlarm alarm, String previousBody, String previousAuthor, Date previousUpdated) {
        this.onNewOrUpdatedAlarm(alarm);
    }

    public void onStickyMemoDeleted(OnmsAlarm alarm, OnmsMemo memo) {
        this.onNewOrUpdatedAlarm(alarm);
    }

    public void onReductionKeyMemoDeleted(OnmsAlarm alarm, OnmsReductionKeyMemo memo) {
        this.onNewOrUpdatedAlarm(alarm);
    }

    public void onLastAutomationTimeUpdated(OnmsAlarm alarm, Date previousLastAutomationTime) {
        this.onNewOrUpdatedAlarm(alarm);
    }

    public void onRelatedAlarmsUpdated(OnmsAlarm alarm, Set<OnmsAlarm> previousRelatedAlarms) {
        this.onNewOrUpdatedAlarm(alarm);
    }

    public void onTicketStateChanged(OnmsAlarm alarm, TroubleTicketState previousState) {
        this.onNewOrUpdatedAlarm(alarm);
    }

    private void forEachListener(Consumer<AlarmLifecycleListener> callback) {
        for (AlarmLifecycleListener listener : this.listeners) {
            try {
                callback.accept(listener);
            }
            catch (Exception e) {
                LOG.error("Error occurred while invoking listener: {}. Skipping.", (Object)listener, (Object)e);
            }
        }
    }

    public void onListenerRegistered(AlarmLifecycleListener listener, Map<String, String> properties) {
        LOG.debug("onListenerRegistered: {} with properties: {}", (Object)listener, properties);
        this.listeners.add(listener);
    }

    public void onListenerUnregistered(AlarmLifecycleListener listener, Map<String, String> properties) {
        LOG.debug("onListenerUnregistered: {} with properties: {}", (Object)listener, properties);
        this.listeners.remove(listener);
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.alarmDao = alarmDao;
    }

    public void setSessionUtils(SessionUtils sessionUtils) {
        this.sessionUtils = sessionUtils;
    }

    public void afterPropertiesSet() {
        this.start();
    }

    public void destroy() {
        this.stop();
    }
}

