/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.snmp.profile.mapper.impl;

import com.google.common.base.Strings;
import java.net.InetAddress;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.config.snmp.SnmpProfile;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.filter.api.FilterParseException;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpProfileMapper;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SnmpProfileMapperImpl
implements SnmpProfileMapper {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpProfileMapperImpl.class);
    @Autowired
    private SnmpAgentConfigFactory agentConfigFactory;
    @Autowired
    private FilterDao filterDao;
    @Autowired
    private LocationAwareSnmpClient locationAwareSnmpClient;
    private static final String SYS_OBJECTID_INSTANCE = ".1.3.6.1.2.1.1.2.0";
    private final SnmpObjId snmpObjId = SnmpObjId.get((String)".1.3.6.1.2.1.1.2.0");

    public SnmpProfileMapperImpl() {
    }

    public SnmpProfileMapperImpl(FilterDao filterDao, SnmpAgentConfigFactory agentConfigFactory, LocationAwareSnmpClient locationAwareSnmpClient) {
        this.agentConfigFactory = Objects.requireNonNull(agentConfigFactory);
        this.filterDao = Objects.requireNonNull(filterDao);
        this.locationAwareSnmpClient = Objects.requireNonNull(locationAwareSnmpClient);
    }

    public CompletableFuture<Optional<SnmpAgentConfig>> getAgentConfigFromProfiles(InetAddress inetAddress, String location, String oid, boolean metaDataInterpolation) {
        CompletableFuture<Optional<SnmpAgentConfig>> future = new CompletableFuture<Optional<SnmpAgentConfig>>();
        List snmpProfiles = this.agentConfigFactory.getProfiles();
        List matchedProfiles = snmpProfiles.stream().filter(snmpProfile -> this.isFilterExpressionValid(inetAddress, snmpProfile.getFilterExpression())).collect(Collectors.toList());
        List<CompletableFuture> futures = matchedProfiles.stream().map(matchedProfile -> this.fitProfile((SnmpProfile)matchedProfile, inetAddress, location, oid)).collect(Collectors.toList());
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        CompletionStage results = allFutures.thenApply(agentConfig -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
        ((CompletableFuture)results).whenComplete((configList, throwable) -> {
            if (throwable == null) {
                Optional<Optional> configOptional = configList.stream().filter(Optional::isPresent).findFirst();
                future.complete(configOptional.orElse(Optional.empty()));
            } else {
                future.complete(Optional.empty());
            }
        });
        return future;
    }

    private CompletableFuture<Optional<SnmpAgentConfig>> fitProfile(SnmpProfile snmpProfile, InetAddress inetAddress, String location, String oid) {
        SnmpObjId snmpObjectId = this.snmpObjId;
        SnmpAgentConfig interpolatedAgentConfig = this.agentConfigFactory.getAgentConfigFromProfile(snmpProfile, inetAddress);
        SnmpAgentConfig agentConfig = this.agentConfigFactory.getAgentConfigFromProfile(snmpProfile, inetAddress, false);
        if (!Strings.isNullOrEmpty((String)oid)) {
            snmpObjectId = SnmpObjId.get((String)oid);
        }
        CompletableFuture<Optional<SnmpAgentConfig>> future = new CompletableFuture<Optional<SnmpAgentConfig>>();
        CompletableFuture snmpResult = this.locationAwareSnmpClient.get(interpolatedAgentConfig, snmpObjectId).withLocation(location).withDescription("Snmp-Profile:" + snmpProfile.getLabel()).execute();
        String objectId = Strings.isNullOrEmpty((String)oid) ? SYS_OBJECTID_INSTANCE : oid;
        snmpResult.whenComplete((snmpValue, throwable) -> {
            if (throwable == null) {
                if (snmpValue != null && !snmpValue.isError()) {
                    future.complete(Optional.of(agentConfig));
                } else {
                    future.complete(Optional.empty());
                }
            } else {
                LOG.info("Exception while doing SNMP get on OID '{}' with profile '{}'", (Object)objectId, (Object)snmpProfile.getLabel());
                future.complete(Optional.empty());
            }
        });
        return future;
    }

    public CompletableFuture<Optional<SnmpAgentConfig>> getAgentConfigFromProfiles(InetAddress inetAddress, String location, boolean metaDataInterpolation) {
        return this.getAgentConfigFromProfiles(inetAddress, location, null, metaDataInterpolation);
    }

    public CompletableFuture<Optional<SnmpAgentConfig>> fitProfile(String profileLabel, InetAddress inetAddress, String location, String oid) {
        Optional agentConfig = Optional.empty();
        if (Strings.isNullOrEmpty((String)profileLabel)) {
            return this.getAgentConfigFromProfiles(inetAddress, location, oid);
        }
        List profiles = this.agentConfigFactory.getProfiles();
        Optional<SnmpProfile> matchingProfile = profiles.stream().filter(profile -> profile.getLabel().equals(profileLabel)).findFirst();
        if (matchingProfile.isPresent()) {
            return this.fitProfile(matchingProfile.get(), inetAddress, location, oid);
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    private boolean isFilterExpressionValid(InetAddress inetAddress, String filterExpression) {
        if (Strings.isNullOrEmpty((String)filterExpression)) {
            return true;
        }
        try {
            return this.filterDao.isValid(inetAddress.getHostAddress(), filterExpression);
        }
        catch (FilterParseException e) {
            LOG.warn("Filter expression '{}' is invalid. ", (Object)filterExpression, (Object)e);
            return false;
        }
    }

    public void setLocationAwareSnmpClient(LocationAwareSnmpClient locationAwareSnmpClient) {
        this.locationAwareSnmpClient = locationAwareSnmpClient;
    }

    public SnmpAgentConfigFactory getAgentConfigFactory() {
        return this.agentConfigFactory;
    }

    public void setAgentConfigFactory(SnmpAgentConfigFactory agentConfigFactory) {
        this.agentConfigFactory = agentConfigFactory;
    }

    public FilterDao getFilterDao() {
        return this.filterDao;
    }

    public void setFilterDao(FilterDao filterDao) {
        this.filterDao = filterDao;
    }
}

