/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jcifs.util.Encdec;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.IJIUnsigned;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIComObjectImpl;
import org.jinterop.dcom.core.JICurrency;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JIInterfacePointerBody;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIStruct;
import org.jinterop.dcom.core.JIUnion;
import org.jinterop.dcom.core.JIUnsignedByte;
import org.jinterop.dcom.core.JIUnsignedFactory;
import org.jinterop.dcom.core.JIUnsignedInteger;
import org.jinterop.dcom.core.JIUnsignedShort;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.core.VariantBody;
import org.jinterop.dcom.impls.automation.IJIDispatch;
import rpc.core.UUID;

final class JIMarshalUnMarshalHelper {
    private static final Logger LOGGER = Logger.getLogger("org.jinterop");
    private static final Map<Class<?>, SerializerDeserializer> mapOfSerializers = new HashMap();

    static byte[] readOctetArrayLE(NetworkDataRepresentation ndr, int length) {
        byte[] bytes = new byte[8];
        ndr.readOctetArray(bytes, 0, 8);
        for (int i = 0; i < 4; ++i) {
            byte t = bytes[i];
            bytes[i] = bytes[7 - i];
            bytes[7 - i] = t;
        }
        return bytes;
    }

    static void writeOctetArrayLE(NetworkDataRepresentation ndr, byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            ndr.writeUnsignedSmall((int)b[b.length - i - 1]);
        }
    }

    static <T> void serialize(NetworkDataRepresentation ndr, Class<?> c, T value, List<JIPointer> defferedPointers, int FLAG) {
        if (c.equals(JIArray.class)) {
            ((JIArray)value).encode(ndr, ((JIArray)value).getArrayInstance(), defferedPointers, FLAG);
        } else {
            if ((c != IJIComObject.class || c != IJIDispatch.class) && value instanceof IJIComObject) {
                c = IJIComObject.class;
            }
            JIMarshalUnMarshalHelper.alignMemberWhileEncoding(ndr, c, value);
            if (c.equals(JIString.class)) {
                ((JIString)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (c.equals(JIPointer.class)) {
                ((JIPointer)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (c.equals(JIStruct.class)) {
                ((JIStruct)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (c.equals(JIUnion.class)) {
                ((JIUnion)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (c.equals(JIInterfacePointer.class)) {
                ((JIInterfacePointer)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (c.equals(JIVariant.class)) {
                ((JIVariant)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (c.equals(VariantBody.class)) {
                ((VariantBody)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (mapOfSerializers.get(c) == null) {
                throw new IllegalStateException(MessageFormat.format(JISystem.getLocalizedMessage(4111), c.toString()));
            }
            mapOfSerializers.get(c).serializeData(ndr, value, defferedPointers, FLAG);
        }
    }

    private static <T> void alignMemberWhileEncoding(NetworkDataRepresentation ndr, Class<?> c, T obj) {
        double index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
        if (c.equals(JIStruct.class)) {
            double align = new Integer(((JIStruct)obj).getAlignment()).doubleValue();
            long i = Math.round(index % align);
            i = (long)(i == 0L ? 0.0 : align - (double)i);
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(JIUnion.class)) {
            double align = new Integer(((JIUnion)obj).getAlignment()).doubleValue();
            long i = Math.round(index % align);
            i = (long)(i == 0L ? 0.0 : align - (double)i);
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(Integer.class) || c.equals(Float.class) || c.equals(JIVariant.class) || c.equals(String.class) || c.equals(JIPointer.class)) {
            long i = Math.round(index % 4.0);
            i = i == 0L ? 0L : 4L - i;
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(Double.class)) {
            long i = Math.round(index % 8.0);
            i = i == 0L ? 0L : 8L - i;
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(Short.class)) {
            long i = Math.round(index % 2.0);
            i = i == 0L ? 0L : 2L - i;
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
        }
    }

    private static <T> void alignMemberWhileDecoding(NetworkDataRepresentation ndr, Class<?> c, T obj) {
        double index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
        if (c.equals(JIStruct.class)) {
            double align = new Integer(((JIStruct)obj).getAlignment()).doubleValue();
            long i = Math.round(index % align);
            i = (long)(i == 0L ? 0.0 : align - (double)i);
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(JIUnion.class)) {
            double align = new Integer(((JIUnion)obj).getAlignment()).doubleValue();
            long i = Math.round(index % align);
            i = (long)(i == 0L ? 0.0 : align - (double)i);
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(Integer.class) || c.equals(Float.class) || c.equals(JIVariant.class) || c.equals(String.class) || c.equals(JIPointer.class)) {
            long i = Math.round(index % 4.0);
            i = i == 0L ? 0L : 4L - i;
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(Double.class)) {
            long i = Math.round(index % 8.0);
            i = i == 0L ? 0L : 8L - i;
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(Short.class)) {
            long i = Math.round(index % 2.0);
            i = i == 0L ? 0L : 2L - i;
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
        }
    }

    static Object deSerialize(NetworkDataRepresentation ndr, Object obj, List<JIPointer> defferedPointers, int FLAG, Map additionalData) {
        Class<?> c;
        Class<?> clazz = c = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        if (c.equals(JIArray.class)) {
            return ((JIArray)obj).decode(ndr, ((JIArray)obj).getArrayClass(), ((JIArray)obj).getDimensions(), defferedPointers, FLAG, additionalData);
        }
        JIMarshalUnMarshalHelper.alignMemberWhileDecoding(ndr, c, obj);
        if (c.equals(JIPointer.class)) {
            JIPointer retVal = ((JIPointer)obj).decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (c.equals(JIStruct.class)) {
            JIStruct retVal = ((JIStruct)obj).decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (c.equals(JIUnion.class)) {
            JIUnion retVal = ((JIUnion)obj).decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (c.equals(JIString.class)) {
            JIString retVal = ((JIString)obj).decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (obj.equals(JIInterfacePointer.class)) {
            JIInterfacePointer retVal = JIInterfacePointer.decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (obj.equals(JIVariant.class)) {
            JIVariant retVal = JIVariant.decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (obj.equals(VariantBody.class)) {
            VariantBody retVal = VariantBody.decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (mapOfSerializers.get(obj) == null) {
            throw new IllegalStateException(MessageFormat.format(JISystem.getLocalizedMessage(4111), obj.toString()));
        }
        return mapOfSerializers.get(obj).deserializeData(ndr, defferedPointers, additionalData, FLAG);
    }

    static int getLengthInBytes(Class c, Object obj, int FLAG) {
        if (obj != null && obj.getClass().equals(JIArray.class)) {
            return ((JIArray)obj).getSizeOfAllElementsInBytes();
        }
        if ((c != IJIComObject.class || c != IJIDispatch.class) && obj instanceof IJIComObject) {
            c = IJIComObject.class;
        }
        if (mapOfSerializers.get(c) == null) {
            throw new IllegalStateException(MessageFormat.format(JISystem.getLocalizedMessage(4111), c.toString()));
        }
        return mapOfSerializers.get(c).getLengthInBytes(obj, FLAG);
    }

    private JIMarshalUnMarshalHelper() {
    }

    static {
        mapOfSerializers.put(Date.class, new DateImpl());
        mapOfSerializers.put(JICurrency.class, new JICurrencyImpl());
        mapOfSerializers.put(VariantBody.class, new JIVariant2Impl());
        mapOfSerializers.put(JIVariant.class, new JIVariantImpl());
        mapOfSerializers.put(Double.class, new DoubleImpl());
        mapOfSerializers.put(Boolean.class, new BooleanImpl());
        mapOfSerializers.put(Short.class, new ShortImpl());
        mapOfSerializers.put(Integer.class, new IntegerImpl());
        mapOfSerializers.put(Float.class, new FloatImpl());
        mapOfSerializers.put(String.class, new StringImpl());
        mapOfSerializers.put(UUID.class, new UUIDImpl());
        mapOfSerializers.put(Byte.class, new ByteImpl());
        mapOfSerializers.put(Long.class, new LongImpl());
        mapOfSerializers.put(Character.class, new CharacterImpl());
        mapOfSerializers.put(JIInterfacePointer.class, new MInterfacePointerImpl());
        mapOfSerializers.put(JIInterfacePointerBody.class, new MInterfacePointerImpl2());
        mapOfSerializers.put(IJIDispatch.class, new IJIComObjectSerDer());
        mapOfSerializers.put(IJIComObject.class, new IJIComObjectSerDer());
        mapOfSerializers.put(JIPointer.class, new PointerImpl());
        mapOfSerializers.put(JIStruct.class, new StructImpl());
        mapOfSerializers.put(JIUnion.class, new UnionImpl());
        mapOfSerializers.put(JIString.class, new JIStringImpl());
        mapOfSerializers.put(JIUnsignedByte.class, new JIUnsignedByteImpl());
        mapOfSerializers.put(JIUnsignedShort.class, new JIUnsignedShortImpl());
        mapOfSerializers.put(JIUnsignedInteger.class, new JIUnsignedIntImpl());
    }

    private static class MInterfacePointerImpl2
    implements SerializerDeserializer {
        private MInterfacePointerImpl2() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            ((JIInterfacePointerBody)value).encode(ndr, FLAG);
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            return JIInterfacePointerBody.decode(ndr, FLAG);
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIInterfacePointerBody)value).getLength();
        }
    }

    private static class MInterfacePointerImpl
    implements SerializerDeserializer {
        private MInterfacePointerImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIInterfacePointer)value).getLength();
        }
    }

    private static class UUIDImpl
    implements SerializerDeserializer {
        private UUIDImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            try {
                ((NdrObject)value).encode(ndr, ndr.getBuffer());
            }
            catch (RuntimeException e) {
                LOGGER.throwing("UUIDImpl", "serializeData", e);
            }
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            return new UUID(ndr.getBuffer());
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return 16;
        }
    }

    private static class JIStringImpl
    implements SerializerDeserializer {
        private JIStringImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            int length = 4;
            if (((JIString)value).getString() == null) {
                return length;
            }
            return (length += ((JIString)value).getType() == 2 ? 0 : 2) + JIMarshalUnMarshalHelper.getLengthInBytes(String.class, ((JIString)value).getString(), ((JIString)value).getType() | FLAG);
        }
    }

    private static class StringImpl
    implements SerializerDeserializer {
        private StringImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            if ((FLAG & 0x4000) != 16384) {
                throw new JIRuntimeException(4165);
            }
            String str = (String)value;
            if (str == null) {
                str = "";
            }
            if ((FLAG & 1) == 1) {
                byte[] strBytes = str.getBytes(StandardCharsets.UTF_16LE);
                ndr.writeUnsignedLong(strBytes.length / 2);
                ndr.writeUnsignedLong(strBytes.length);
                ndr.writeUnsignedLong(strBytes.length / 2);
                for (int i = 0; i < strBytes.length; ++i) {
                    ndr.writeUnsignedSmall((int)strBytes[i]);
                }
            } else if ((FLAG & 2) == 2) {
                int strlen = (int)Math.round((double)str.length() / 2.0);
                ndr.writeUnsignedLong(strlen + 1);
                ndr.writeUnsignedLong(0);
                ndr.writeUnsignedLong(strlen + 1);
                if (str.length() != 0) {
                    ndr.writeCharacterArray(str.toCharArray(), 0, str.length());
                    if (str.length() % 2 != 0) {
                        ndr.writeUnsignedSmall(0);
                    }
                }
                ndr.writeUnsignedShort(0);
            } else if ((FLAG & 4) == 4) {
                byte[] strBytes = str.getBytes(StandardCharsets.UTF_16LE);
                ndr.writeUnsignedLong(strBytes.length / 2 + 1);
                ndr.writeUnsignedLong(0);
                ndr.writeUnsignedLong(strBytes.length / 2 + 1);
                for (int i = 0; i < strBytes.length; ++i) {
                    ndr.writeUnsignedSmall((int)strBytes[i]);
                }
                ndr.writeUnsignedShort(0);
            }
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            if ((FLAG & 0x4000) != 16384) {
                throw new JIRuntimeException(4165);
            }
            int retVal = -1;
            String retString = null;
            if ((FLAG & 1) == 1) {
                ndr.readUnsignedLong();
                ndr.readUnsignedLong();
                int actuallength = ndr.readUnsignedLong() * 2;
                byte[] buffer = new byte[actuallength];
                for (int i = 0; i < actuallength; ++i) {
                    retVal = ndr.readUnsignedSmall();
                    buffer[i] = (byte)retVal;
                }
                retString = new String(buffer, StandardCharsets.UTF_16LE);
            } else if ((FLAG & 2) == 2) {
                int actuallength = ndr.readUnsignedLong();
                if (actuallength == 0) {
                    return null;
                }
                ndr.readUnsignedLong();
                ndr.readUnsignedLong();
                char[] ret = new char[actuallength * 2 - 2];
                ndr.readCharacterArray(ret, 0, actuallength * 2 - 2);
                retString = ret[ret.length - 1] == '0' ? new String(ret, 0, ret.length - 1) : new String(ret);
                ndr.readUnsignedShort();
            } else if ((FLAG & 4) == 4) {
                int maxlength = ndr.readUnsignedLong();
                if (maxlength == 0) {
                    return null;
                }
                ndr.readUnsignedLong();
                int actuallength = ndr.readUnsignedLong() * 2;
                byte[] buffer = new byte[actuallength - 2];
                for (int i = 0; i < actuallength - 2; ++i) {
                    retVal = ndr.readUnsignedSmall();
                    buffer[i] = (byte)retVal;
                }
                if (actuallength != 0) {
                    ndr.readUnsignedShort();
                }
                retString = new String(buffer, StandardCharsets.UTF_16LE);
            }
            return retString;
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            int length = 12;
            if ((FLAG & 1) != 1) {
                length += 2;
            }
            if ((FLAG & 2) == 2) {
                length += ((CharSequence)value).length();
                if (((CharSequence)value).length() % 2 != 0) {
                    ++length;
                }
            } else {
                length += ((CharSequence)value).length() * 2;
            }
            return length;
        }
    }

    private static class FloatImpl
    implements SerializerDeserializer {
        private FloatImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            if (value == null) {
                value = Float.valueOf(Float.NaN);
            }
            ndr.getBuffer().align(4);
            Encdec.enc_floatle((float)((Number)value).floatValue(), (byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex());
            ndr.getBuffer().advance(4);
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            ndr.getBuffer().align(4);
            Float b = Float.valueOf(Encdec.dec_floatle((byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex()));
            ndr.getBuffer().advance(4);
            return b;
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return 4;
        }
    }

    private static class DateImpl
    implements SerializerDeserializer {
        private DateImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            ndr.getBuffer().align(8);
            Encdec.enc_doublele((double)this.convertMillisecondsToWindowsTime(((Date)value).getTime()), (byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex());
            ndr.getBuffer().advance(8);
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            ndr.getBuffer().align(8);
            Date b = new Date(this.convertWindowsTimeToMilliseconds(Encdec.dec_doublele((byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex())));
            ndr.getBuffer().advance(8);
            return b;
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return 8;
        }

        private long convertWindowsTimeToMilliseconds(double comTime) {
            long result = 0L;
            Calendar cal = Calendar.getInstance();
            result = Math.round(8.64E7 * (comTime -= 25569.0)) - (long)cal.get(15);
            cal.setTime(new Date(result));
            return result -= (long)cal.get(16);
        }

        private double convertMillisecondsToWindowsTime(long milliseconds) {
            double result = 0.0;
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(milliseconds);
            result = (double)(milliseconds += (long)(cal.get(15) + cal.get(16))) / 8.64E7 + 25569.0;
            return result;
        }
    }

    private static class JICurrencyImpl
    implements SerializerDeserializer {
        private JICurrencyImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            JICurrency currency = (JICurrency)value;
            int units = currency.getUnits();
            int fractionalUnits = currency.getFractionalUnits();
            double p = units + fractionalUnits / 10000;
            int toSend = ~((int)(p * 10000.0)) + 1;
            String toSend2 = Integer.toHexString(toSend);
            int hibytes = 0;
            int lowbytes = 0;
            if (toSend2.length() > 8) {
                lowbytes = Integer.valueOf(toSend2.substring(8), 16);
                hibytes = Integer.valueOf(toSend2.substring(0, 8), 16);
            } else {
                lowbytes = toSend;
                if (toSend < 0) {
                    hibytes = -1;
                }
            }
            double index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
            long i = Math.round(index % 8.0);
            i = i == 0L ? 0L : 8L - i;
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
            JIStruct struct = new JIStruct();
            try {
                struct.addMember(lowbytes);
                struct.addMember(hibytes);
            }
            catch (JIException jIException) {
                // empty catch block
            }
            JIMarshalUnMarshalHelper.serialize(ndr, JIStruct.class, struct, null, FLAG);
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            double index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
            long i = Math.round(index % 8.0);
            i = i == 0L ? 0L : 8L - i;
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
            int lowbyte = ndr.readUnsignedLong();
            int hibyte = ndr.readUnsignedLong();
            if (hibyte < 0) {
                lowbyte = -1 * Math.abs(lowbyte);
            }
            return new JICurrency((lowbyte - lowbyte % 10000) / 10000, lowbyte % 10000);
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return 8;
        }
    }

    private static class DoubleImpl
    implements SerializerDeserializer {
        private DoubleImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            if (value == null) {
                value = Double.NaN;
            }
            ndr.getBuffer().align(8);
            Encdec.enc_doublele((double)((Number)value).doubleValue(), (byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex());
            ndr.getBuffer().advance(8);
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            ndr.getBuffer().align(8);
            Double b = Encdec.dec_doublele((byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex());
            ndr.getBuffer().advance(8);
            return b;
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return 8;
        }
    }

    private static class LongImpl
    implements SerializerDeserializer {
        private LongImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            if (value == null) {
                value = Long.MIN_VALUE;
            }
            ndr.getBuffer().align(8);
            Encdec.enc_uint64le((long)((Number)value).longValue(), (byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex());
            ndr.getBuffer().advance(8);
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            ndr.getBuffer().align(8);
            Long b = Encdec.dec_uint64le((byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex());
            ndr.getBuffer().advance(8);
            return b;
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return 8;
        }
    }

    private static class IntegerImpl
    implements SerializerDeserializer {
        private IntegerImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            if (value == null) {
                value = Integer.MIN_VALUE;
            }
            ndr.writeUnsignedLong(((Number)value).intValue());
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            return ndr.readUnsignedLong();
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return 4;
        }
    }

    private static class BooleanImpl
    implements SerializerDeserializer {
        private BooleanImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            if (value == null) {
                value = Boolean.FALSE;
            }
            if ((FLAG & 0x2000) == 8192) {
                ndr.writeUnsignedShort((Boolean)value == true ? 65535 : 0);
            } else {
                ndr.writeBoolean(((Boolean)value).booleanValue());
            }
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            int s;
            Boolean b = null;
            b = (FLAG & 0x2000) == 8192 ? ((s = ndr.readUnsignedShort()) != 0 ? Boolean.TRUE : Boolean.FALSE) : Boolean.valueOf(ndr.readBoolean());
            return b;
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            if ((FLAG & 0x2000) == 8192) {
                return 2;
            }
            return 1;
        }
    }

    private static class ShortImpl
    implements SerializerDeserializer {
        private ShortImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            if (value == null) {
                value = (short)Short.MIN_VALUE;
            }
            ndr.writeUnsignedShort((int)((Number)value).shortValue());
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            Short s = (short)ndr.readUnsignedShort();
            return s;
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return 4;
        }
    }

    private static class ByteImpl
    implements SerializerDeserializer {
        private ByteImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            ndr.writeUnsignedSmall((int)((Number)value).byteValue());
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            Byte c = (byte)ndr.readUnsignedSmall();
            return c;
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return 1;
        }
    }

    private static class CharacterImpl
    implements SerializerDeserializer {
        private CharacterImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            ndr.writeUnsignedSmall((int)((Character)value).charValue());
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            Character c = Character.valueOf((char)ndr.readUnsignedSmall());
            return c;
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return 1;
        }
    }

    private static class JIVariantImpl
    implements SerializerDeserializer {
        private JIVariantImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            try {
                return ((JIVariant)value).getLengthInBytes(FLAG);
            }
            catch (JIException e) {
                throw new JIRuntimeException(e.getErrorCode());
            }
        }
    }

    private static class JIVariant2Impl
    implements SerializerDeserializer {
        private JIVariant2Impl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return ((VariantBody)value).getLengthInBytes();
        }
    }

    private static class IJIComObjectSerDer
    implements SerializerDeserializer {
        private IJIComObjectSerDer() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            JIMarshalUnMarshalHelper.serialize(ndr, JIInterfacePointer.class, ((IJIComObject)value).internal_getInterfacePointer(), defferedPointers, FLAG);
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            JISession session = (JISession)additionalData.get("CURRENTSESSION");
            JIComObjectImpl comObject = new JIComObjectImpl(session, (JIInterfacePointer)JIMarshalUnMarshalHelper.deSerialize(ndr, JIInterfacePointer.class, defferedPointers, FLAG, additionalData));
            ((Collection)additionalData.get("COMOBJECTS")).add(comObject);
            return comObject;
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            JIInterfacePointer interfacePointer = ((IJIComObject)value).internal_getInterfacePointer();
            return interfacePointer.getLength();
        }
    }

    private static class UnionImpl
    implements SerializerDeserializer {
        private UnionImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIUnion)value).getLength();
        }
    }

    private static class StructImpl
    implements SerializerDeserializer {
        private StructImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIStruct)value).getLength();
        }
    }

    private static class JIUnsignedShortImpl
    implements SerializerDeserializer {
        private JIUnsignedShortImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            JIMarshalUnMarshalHelper.serialize(ndr, Short.class, ((IJIUnsigned)value).getValue().shortValue(), null, FLAG);
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            Short b = (Short)JIMarshalUnMarshalHelper.deSerialize(ndr, Short.class, null, FLAG, additionalData);
            return JIUnsignedFactory.getUnsigned(b & 0xFFFF, 512);
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return 2;
        }
    }

    private static class JIUnsignedByteImpl
    implements SerializerDeserializer {
        private JIUnsignedByteImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            JIMarshalUnMarshalHelper.serialize(ndr, Byte.class, ((IJIUnsigned)value).getValue().byteValue(), null, FLAG);
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            Byte b = (Byte)JIMarshalUnMarshalHelper.deSerialize(ndr, Byte.class, null, FLAG, additionalData);
            return JIUnsignedFactory.getUnsigned((short)(b & 0xFF), 256);
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return 1;
        }
    }

    private static class JIUnsignedIntImpl
    implements SerializerDeserializer {
        private JIUnsignedIntImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, ((IJIUnsigned)value).getValue().intValue(), null, FLAG);
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            Integer b = (Integer)JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, null, FLAG, additionalData);
            return JIUnsignedFactory.getUnsigned((long)b.intValue() & 0xFFFFFFFFL, 1024);
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return 4;
        }
    }

    private static class PointerImpl
    implements SerializerDeserializer {
        private PointerImpl() {
        }

        @Override
        public void serializeData(NetworkDataRepresentation ndr, Object value, List<JIPointer> defferedPointers, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        @Override
        public Object deserializeData(NetworkDataRepresentation ndr, List<JIPointer> defferedPointers, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        @Override
        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIPointer)value).getLength();
        }
    }

    private static interface SerializerDeserializer {
        public void serializeData(NetworkDataRepresentation var1, Object var2, List<JIPointer> var3, int var4);

        public Object deserializeData(NetworkDataRepresentation var1, List<JIPointer> var2, Map var3, int var4);

        public int getLengthInBytes(Object var1, int var2);
    }
}

