/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jinterop.dcom.common.IJIUnreferenced;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICallBuilder;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JISession;
import rpc.core.UUID;

final class JIComObjectImpl
implements IJIComObject {
    private static final Logger LOGGER = Logger.getLogger("org.jinterop");
    private static final long serialVersionUID = -1661750453596032089L;
    private boolean isDual = false;
    private boolean dualInfo = false;
    private transient JISession session = null;
    private JIInterfacePointer ptr = null;
    private Map<String, Object[]> connectionPointInfo = null;
    private int timeout = 0;
    private final boolean isLocal;

    JIComObjectImpl(JISession session, JIInterfacePointer ptr) {
        this(session, ptr, false);
    }

    JIComObjectImpl(JISession session, JIInterfacePointer ptr, boolean isLocal) {
        this.session = session;
        this.ptr = ptr;
        this.isLocal = isLocal;
    }

    void replaceMembers(IJIComObject comObject) {
        this.session = comObject.getAssociatedSession();
        this.ptr = comObject.internal_getInterfacePointer();
    }

    private void checkLocal() {
        if (this.session == null) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4176));
        }
        if (this.isLocalReference()) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(-2147467263));
        }
    }

    @Override
    public IJIComObject queryInterface(String iid) throws JIException {
        this.checkLocal();
        return this.session.getStub().getInterface(iid, this.ptr.getIPID());
    }

    @Override
    public void addRef() throws JIException {
        this.checkLocal();
        JICallBuilder obj = new JICallBuilder(true);
        obj.setParentIpid(this.ptr.getIPID());
        obj.setOpnum(1);
        obj.addInParamAsShort((short)1, 0);
        JIArray array = new JIArray(new UUID[]{new UUID(this.ptr.getIPID())}, true);
        obj.addInParamAsArray(array, 0);
        obj.addInParamAsInt(5, 0);
        obj.addInParamAsInt(0, 0);
        obj.addOutParamAsType(Short.class, 0);
        obj.addOutParamAsType(Integer.class, 0);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "addRef: Adding 5 references for {0} session: {1}", new Object[]{this.ptr.getIPID(), this.session.getSessionIdentifier()});
        }
        this.session.getStub2().addRef_ReleaseRef(obj);
        if (obj.getResultAsIntAt(1) != 0) {
            throw new JIException(obj.getResultAsIntAt(1), (Throwable)null);
        }
    }

    @Override
    public void release() throws JIException {
        this.checkLocal();
        JICallBuilder obj = new JICallBuilder(true);
        obj.setParentIpid(this.ptr.getIPID());
        obj.setOpnum(2);
        obj.addInParamAsShort((short)1, 0);
        JIArray array = new JIArray(new UUID[]{new UUID(this.ptr.getIPID())}, true);
        obj.addInParamAsArray(array, 0);
        obj.addInParamAsInt(5, 0);
        obj.addInParamAsInt(0, 0);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.WARNING, "RELEASE called directly ! removing 5 references for {0} session: {1}", new Object[]{this.ptr.getIPID(), this.session.getSessionIdentifier()});
        }
        this.session.getStub2().addRef_ReleaseRef(obj);
    }

    @Override
    public Object[] call(JICallBuilder obj) throws JIException {
        this.checkLocal();
        return this.call(obj, this.timeout);
    }

    @Override
    public JIInterfacePointer internal_getInterfacePointer() {
        return this.ptr == null ? this.session.getStub().getServerInterfacePointer() : this.ptr;
    }

    @Override
    public String getIpid() {
        return this.ptr.getIPID();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JIComObjectImpl)) {
            return false;
        }
        return this.ptr.getIPID().equalsIgnoreCase(((IJIComObject)obj).getIpid());
    }

    public int hashCode() {
        return this.ptr.getIPID().hashCode();
    }

    @Override
    public JISession getAssociatedSession() {
        return this.session;
    }

    @Override
    public String getInterfaceIdentifier() {
        return this.ptr.getIID();
    }

    @Override
    public synchronized boolean isDispatchSupported() {
        this.checkLocal();
        if (!this.dualInfo) {
            try {
                IJIComObject comObject = this.queryInterface("00020400-0000-0000-c000-000000000046");
                comObject.release();
                this.setIsDual(true);
            }
            catch (JIException e) {
                this.setIsDual(false);
            }
        }
        return this.isDual;
    }

    @Override
    public synchronized String internal_setConnectionInfo(IJIComObject connectionPoint, Integer cookie) {
        this.checkLocal();
        if (this.connectionPointInfo == null) {
            this.connectionPointInfo = new HashMap<String, Object[]>();
        }
        String uniqueId = UUID.createHexString();
        this.connectionPointInfo.put(uniqueId, new Object[]{connectionPoint, cookie});
        return uniqueId;
    }

    @Override
    public synchronized Object[] internal_getConnectionInfo(String identifier) {
        this.checkLocal();
        return this.connectionPointInfo.get(identifier);
    }

    @Override
    public synchronized Object[] internal_removeConnectionInfo(String identifier) {
        this.checkLocal();
        return this.connectionPointInfo.remove(identifier);
    }

    @Override
    public IJIUnreferenced getUnreferencedHandler() {
        this.checkLocal();
        return this.session.getUnreferencedHandler(this.getIpid());
    }

    @Override
    public void registerUnreferencedHandler(IJIUnreferenced unreferenced) {
        this.checkLocal();
        this.session.registerUnreferencedHandler(this.getIpid(), unreferenced);
    }

    @Override
    public void unregisterUnreferencedHandler() {
        this.checkLocal();
        this.session.unregisterUnreferencedHandler(this.getIpid());
    }

    @Override
    public Object[] call(JICallBuilder obj, int socketTimeout) throws JIException {
        this.checkLocal();
        obj.attachSession(this.session);
        obj.setParentIpid(this.ptr.getIPID());
        if (socketTimeout != 0) {
            return this.session.getStub().call(obj, this.ptr.getIID(), socketTimeout);
        }
        return this.session.getStub().call(obj, this.ptr.getIID());
    }

    @Override
    public int getInstanceLevelSocketTimeout() {
        this.checkLocal();
        return this.timeout;
    }

    @Override
    public void setInstanceLevelSocketTimeout(int timeout) {
        this.checkLocal();
        this.timeout = timeout;
    }

    @Override
    public void internal_setDeffered(boolean deffered) {
        this.ptr.setDeffered(deffered);
    }

    @Override
    public boolean isLocalReference() {
        return this.isLocal;
    }

    void setIsDual(boolean isDual) {
        this.dualInfo = true;
        this.isDual = isDual;
    }

    public String toString() {
        return "IJIComObject[" + this.internal_getInterfacePointer() + " , session: " + this.getAssociatedSession().getSessionIdentifier() + ", isLocal: " + this.isLocalReference() + "]";
    }
}

