/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.tftp.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.net.io.FromNetASCIIOutputStream;
import org.apache.commons.net.tftp.TFTP;
import org.apache.commons.net.tftp.TFTPAckPacket;
import org.apache.commons.net.tftp.TFTPDataPacket;
import org.apache.commons.net.tftp.TFTPErrorPacket;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;
import org.apache.commons.net.tftp.TFTPReadRequestPacket;
import org.apache.commons.net.tftp.TFTPWriteRequestPacket;
import org.opennms.features.deviceconfig.tftp.TftpFileReceiver;
import org.opennms.features.deviceconfig.tftp.TftpServer;
import org.opennms.features.deviceconfig.tftp.TftpStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TftpServerImpl
implements TftpServer,
Runnable,
AutoCloseable {
    private static Logger LOG = LoggerFactory.getLogger(TftpServerImpl.class);
    private final HashSet<TFTPTransfer> transfers_ = new HashSet();
    private volatile boolean shutdownServer;
    private TFTP serverTftp_;
    private int port_ = 69;
    private InetAddress laddr_ = new InetSocketAddress(0).getAddress();
    private Exception serverException;
    private int maxTimeoutRetries_ = 3;
    private int socketTimeout_;
    private Thread serverThread;
    private Set<TftpFileReceiver> receivers = new HashSet<TftpFileReceiver>();
    private long maximumReceiveSize = 50000L;
    private TftpStatisticsImpl statistics = new TftpStatisticsImpl();

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public int getPort() {
        return this.port_;
    }

    public int getMaxTimeoutRetries() {
        return this.maxTimeoutRetries_;
    }

    public int getSocketTimeout() {
        return this.socketTimeout_;
    }

    public boolean isRunning() throws Exception {
        if (this.shutdownServer && this.serverException != null) {
            throw this.serverException;
        }
        return !this.shutdownServer;
    }

    public void launch() throws IOException {
        LOG.info("Starting TFTP Server on port " + this.port_);
        this.shutdownServer = false;
        this.serverTftp_ = new TFTP();
        this.socketTimeout_ = this.serverTftp_.getDefaultTimeout();
        this.serverTftp_.setDefaultTimeout(0);
        try {
            if (this.laddr_ != null) {
                this.serverTftp_.open(this.port_, this.laddr_);
            } else {
                this.serverTftp_.open(this.port_);
            }
        }
        catch (SocketException e) {
            this.statistics.incErrors();
            throw new IOException("could not open tftp server - port: " + this.port_ + (String)(this.laddr_ != null ? "; address: " + String.valueOf(this.laddr_) : ""), e);
        }
        this.serverThread = new Thread(this);
        this.serverThread.setDaemon(true);
        this.serverThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.shutdownServer) {
                TFTPPacket tftpPacket = this.serverTftp_.receive();
                TFTPTransfer tt = new TFTPTransfer(tftpPacket);
                HashSet<TFTPTransfer> hashSet = this.transfers_;
                synchronized (hashSet) {
                    this.transfers_.add(tt);
                }
                Thread thread = new Thread(tt);
                thread.setDaemon(true);
                thread.start();
            }
        }
        catch (Exception e) {
            if (!this.shutdownServer) {
                this.serverException = e;
                this.statistics.incErrors();
                LOG.error("Unexpected Error in TFTP Server - Server shut down!", (Throwable)e);
            }
        }
        finally {
            this.shutdownServer = true;
            if (this.serverTftp_ != null && this.serverTftp_.isOpen()) {
                this.serverTftp_.close();
            }
        }
    }

    void sendData(TFTP tftp, TFTPPacket data) throws IOException {
        tftp.bufferedSend(data);
    }

    public void setMaxTimeoutRetries(int retries) {
        if (retries < 0) {
            throw new IllegalArgumentException("Invalid Value");
        }
        this.maxTimeoutRetries_ = retries;
    }

    public void setSocketTimeout(int timeout) {
        if (timeout < 10) {
            throw new IllegalArgumentException("Invalid Value");
        }
        this.socketTimeout_ = timeout;
    }

    public void setAddress(String addr) throws UnknownHostException {
        this.laddr_ = InetAddress.getByName(addr);
    }

    public void setPort(int port) {
        this.port_ = port;
    }

    public void setMaximumReceiveSize(long maximumReceiveSize) {
        this.maximumReceiveSize = maximumReceiveSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.shutdownServer = true;
        HashSet<TFTPTransfer> hashSet = this.transfers_;
        synchronized (hashSet) {
            Iterator<TFTPTransfer> it = this.transfers_.iterator();
            while (it.hasNext()) {
                it.next().shutdown();
            }
        }
        if (this.serverTftp_ != null) {
            try {
                this.serverTftp_.close();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (this.serverThread != null) {
            try {
                this.serverThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(TftpFileReceiver receiver) throws IOException {
        Set<TftpFileReceiver> set = this.receivers;
        synchronized (set) {
            if (this.serverTftp_ == null) {
                this.launch();
            }
            this.receivers.add(receiver);
            LOG.info("Registered new TFTP receiver, current receiver count {}", (Object)this.receivers.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(TftpFileReceiver receiver) {
        Set<TftpFileReceiver> set = this.receivers;
        synchronized (set) {
            this.receivers.remove(receiver);
            LOG.info("Unregistered TFTP receiver, current receiver count {}", (Object)this.receivers.size());
            if (this.receivers.isEmpty()) {
                LOG.info("No receivers exist currently, closing the tftp server");
                this.close();
                this.serverTftp_ = null;
            }
        }
    }

    @Override
    public TftpStatistics getStatistics() {
        return this.statistics.clone();
    }

    @Override
    public TftpStatistics getAndResetStatistics() {
        return this.statistics.cloneAndReset();
    }

    private static class TftpStatisticsImpl
    implements TftpStatistics,
    Cloneable {
        private int filesReceived;
        private long bytesReceived;
        private int errors;
        private int warnings;

        private TftpStatisticsImpl() {
        }

        @Override
        public synchronized int filesReceived() {
            return this.filesReceived;
        }

        @Override
        public synchronized long bytesReceived() {
            return this.bytesReceived;
        }

        @Override
        public synchronized int errors() {
            return this.errors;
        }

        @Override
        public synchronized int warnings() {
            return this.warnings;
        }

        public synchronized void reset() {
            this.filesReceived = 0;
            this.bytesReceived = 0L;
            this.errors = 0;
        }

        public synchronized void incFilesReceived() {
            ++this.filesReceived;
        }

        public synchronized void incBytesReceived(long bytes) {
            this.bytesReceived += bytes;
        }

        public synchronized void incErrors() {
            ++this.errors;
        }

        public synchronized void incWarnings() {
            ++this.warnings;
        }

        public synchronized TftpStatisticsImpl clone() {
            try {
                return (TftpStatisticsImpl)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public synchronized TftpStatisticsImpl cloneAndReset() {
            TftpStatisticsImpl c = this.clone();
            this.reset();
            return c;
        }
    }

    private class TFTPTransfer
    implements Runnable {
        private final TFTPPacket tftpPacket_;
        private boolean shutdownTransfer;
        TFTP transferTftp_;

        public TFTPTransfer(TFTPPacket tftpPacket) {
            this.tftpPacket_ = tftpPacket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleWrite(TFTPWriteRequestPacket twrp) throws IOException, TFTPPacketException {
            block27: {
                ByteArrayOutputStream underlyingByteArrayOutputStream;
                long bytesReceived = 0L;
                try (ByteArrayOutputStream bos = underlyingByteArrayOutputStream = new ByteArrayOutputStream();){
                    ArrayList<TftpFileReceiver> rs;
                    TFTPPacket dataPacket;
                    int lastBlock = 0;
                    String fileName = twrp.getFilename();
                    try {
                        if (twrp.getMode() == 0) {
                            bos = new FromNetASCIIOutputStream((OutputStream)bos);
                        }
                    }
                    catch (Exception e) {
                        TftpServerImpl.this.statistics.incErrors();
                        LOG.error("can not handle net-ascii mode", (Throwable)e);
                        this.transferTftp_.bufferedSend((TFTPPacket)new TFTPErrorPacket(twrp.getAddress(), twrp.getPort(), 0, e.getMessage()));
                        if (bos != null) {
                            ((OutputStream)bos).close();
                        }
                        return;
                    }
                    TFTPAckPacket lastSentAck = new TFTPAckPacket(twrp.getAddress(), twrp.getPort(), 0);
                    TftpServerImpl.this.sendData(this.transferTftp_, (TFTPPacket)lastSentAck);
                    while (true) {
                        dataPacket = null;
                        int timeoutCount = 0;
                        while (!(this.shutdownTransfer || dataPacket != null && dataPacket.getAddress().equals(twrp.getAddress()) && dataPacket.getPort() == twrp.getPort())) {
                            if (dataPacket != null) {
                                TftpServerImpl.this.statistics.incWarnings();
                                LOG.warn("TFTP Server ignoring message from unexpected source.");
                                this.transferTftp_.bufferedSend((TFTPPacket)new TFTPErrorPacket(dataPacket.getAddress(), dataPacket.getPort(), 5, "Unexpected Host or Port"));
                            }
                            try {
                                dataPacket = this.transferTftp_.bufferedReceive();
                            }
                            catch (SocketTimeoutException e) {
                                TftpServerImpl.this.statistics.incErrors();
                                LOG.error("did not receive data packet", (Throwable)e);
                                if (timeoutCount >= TftpServerImpl.this.maxTimeoutRetries_) {
                                    throw e;
                                }
                                this.transferTftp_.bufferedSend((TFTPPacket)lastSentAck);
                                ++timeoutCount;
                            }
                        }
                        if (dataPacket instanceof TFTPWriteRequestPacket) {
                            lastSentAck = new TFTPAckPacket(twrp.getAddress(), twrp.getPort(), 0);
                            this.transferTftp_.bufferedSend((TFTPPacket)lastSentAck);
                            continue;
                        }
                        if (dataPacket == null || !(dataPacket instanceof TFTPDataPacket)) {
                            if (!this.shutdownTransfer) {
                                TftpServerImpl.this.statistics.incErrors();
                                LOG.error("Unexpected response from tftp client during transfer (" + String.valueOf(dataPacket) + ").  Transfer aborted.");
                            }
                            break block27;
                        }
                        int block = ((TFTPDataPacket)dataPacket).getBlockNumber();
                        byte[] data = ((TFTPDataPacket)dataPacket).getData();
                        int dataLength = ((TFTPDataPacket)dataPacket).getDataLength();
                        int dataOffset = ((TFTPDataPacket)dataPacket).getDataOffset();
                        if (block > lastBlock || lastBlock == 65535 && block == 0) {
                            TftpServerImpl.this.statistics.incBytesReceived(dataLength);
                            if ((bytesReceived += (long)dataLength) > TftpServerImpl.this.maximumReceiveSize) {
                                TftpServerImpl.this.statistics.incErrors();
                                LOG.error("Maximum receive size exceeded - address: {}, fileName: {}; max: {}; received: ", new Object[]{twrp.getAddress(), twrp.getFilename(), TftpServerImpl.this.maximumReceiveSize, bytesReceived});
                                this.transferTftp_.bufferedSend((TFTPPacket)new TFTPErrorPacket(dataPacket.getAddress(), dataPacket.getPort(), 3, "Maximum size (" + TftpServerImpl.this.maximumReceiveSize + ") exceeded"));
                                break block27;
                            }
                            ((OutputStream)bos).write(data, dataOffset, dataLength);
                            lastBlock = block;
                        }
                        lastSentAck = new TFTPAckPacket(twrp.getAddress(), twrp.getPort(), block);
                        TftpServerImpl.this.sendData(this.transferTftp_, (TFTPPacket)lastSentAck);
                        if (dataLength < 512) break;
                    }
                    ((OutputStream)bos).close();
                    byte[] content = underlyingByteArrayOutputStream.toByteArray();
                    TftpServerImpl.this.statistics.incFilesReceived();
                    Set<TftpFileReceiver> set = TftpServerImpl.this.receivers;
                    synchronized (set) {
                        rs = new ArrayList<TftpFileReceiver>(TftpServerImpl.this.receivers);
                    }
                    rs.forEach(r -> r.onFileReceived(twrp.getAddress(), fileName, content));
                    for (int i = 0; i < TftpServerImpl.this.maxTimeoutRetries_; ++i) {
                        try {
                            dataPacket = this.transferTftp_.bufferedReceive();
                        }
                        catch (SocketTimeoutException e) {
                            break;
                        }
                        if (!(dataPacket == null || dataPacket.getAddress().equals(twrp.getAddress()) && dataPacket.getPort() == twrp.getPort())) {
                            TftpServerImpl.this.statistics.incErrors();
                            LOG.error("unexpected host or port - expectedHost: {}; expectedPort: {}; actualHost: {}; actualPort: {}", new Object[]{twrp.getAddress(), twrp.getPort(), dataPacket.getAddress(), dataPacket.getPort()});
                            this.transferTftp_.bufferedSend((TFTPPacket)new TFTPErrorPacket(dataPacket.getAddress(), dataPacket.getPort(), 5, "Unexpected Host or Port"));
                            continue;
                        }
                        this.transferTftp_.bufferedSend((TFTPPacket)lastSentAck);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.transferTftp_ = new TFTP();
                this.transferTftp_.beginBufferedOps();
                this.transferTftp_.setDefaultTimeout(TftpServerImpl.this.socketTimeout_);
                this.transferTftp_.open();
                if (this.tftpPacket_ instanceof TFTPReadRequestPacket) {
                    TftpServerImpl.this.statistics.incWarnings();
                    LOG.warn("illegal operation; tried to read file - host: ", (Object)this.tftpPacket_.getAddress());
                    this.transferTftp_.bufferedSend((TFTPPacket)new TFTPErrorPacket(this.tftpPacket_.getAddress(), this.tftpPacket_.getPort(), 4, "Read not allowed by server."));
                } else if (this.tftpPacket_ instanceof TFTPWriteRequestPacket) {
                    this.handleWrite((TFTPWriteRequestPacket)this.tftpPacket_);
                } else {
                    TftpServerImpl.this.statistics.incWarnings();
                    LOG.warn("Unsupported TFTP request (" + String.valueOf(this.tftpPacket_) + ") - ignored.");
                }
            }
            catch (Exception e) {
                if (!this.shutdownTransfer) {
                    TftpServerImpl.this.statistics.incErrors();
                    LOG.error("Unexpected Error in during TFTP file transfer.  Transfer aborted.", (Throwable)e);
                }
            }
            finally {
                try {
                    if (this.transferTftp_ != null && this.transferTftp_.isOpen()) {
                        this.transferTftp_.endBufferedOps();
                        this.transferTftp_.close();
                    }
                }
                catch (Exception exception) {}
                HashSet<TFTPTransfer> hashSet = TftpServerImpl.this.transfers_;
                synchronized (hashSet) {
                    TftpServerImpl.this.transfers_.remove(this);
                }
            }
        }

        public void shutdown() {
            this.shutdownTransfer = true;
            try {
                this.transferTftp_.close();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }
}

