/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;
import org.jolokia.shaded.org.json.simple.JSONObject;
import org.jolokia.util.ClassUtil;

public class WebsphereDetector
extends AbstractServerDetector {
    private static final Pattern SERVER_VERSION_PATTERN = Pattern.compile("^Version\\s+([0-9.]+)\\s*$.*?^Build Date\\s+([0-9/]+)\\s*$", 42);
    public static final String INTERNAL_ERROR_MSG = "Internal: Found AdminServiceFactory but can not call methods on it (wrong WAS version ?)";
    private boolean isWebsphere = ClassUtil.checkForClass("com.ibm.websphere.management.AdminServiceFactory");
    private boolean isWebsphere7 = ClassUtil.checkForClass("com.ibm.websphere.management.AdminContext");
    private boolean isWebsphere6 = this.isWebsphere && !this.isWebsphere7;

    @Override
    public ServerHandle detect(MBeanServerExecutor pMBeanServerExecutor) {
        String serverVersion = this.getSingleStringAttribute(pMBeanServerExecutor, "*:j2eeType=J2EEServer,type=Server,*", "serverVersion");
        if (serverVersion != null && serverVersion.contains("WebSphere")) {
            Matcher matcher = SERVER_VERSION_PATTERN.matcher(serverVersion);
            if (matcher.find()) {
                String version = matcher.group(1);
                String date = matcher.group(2);
                JSONObject extraInfo = new JSONObject();
                if (date != null) {
                    extraInfo.put("buildDate", date);
                }
                return new WebsphereServerHandle(version, extraInfo.size() > 0 ? extraInfo : null);
            }
            return null;
        }
        if (this.isWebsphere) {
            return new WebsphereServerHandle(this.isWebsphere6 ? "6" : "7 or 8", null);
        }
        return null;
    }

    @Override
    public void addMBeanServers(Set<MBeanServerConnection> servers) {
        try {
            Method getMBeanFactoryMethod;
            Object mbeanFactory;
            Class adminServiceClass = ClassUtil.classForName("com.ibm.websphere.management.AdminServiceFactory", this.getClass().getClassLoader());
            if (adminServiceClass != null && (mbeanFactory = (getMBeanFactoryMethod = adminServiceClass.getMethod("getMBeanFactory", new Class[0])).invoke(null, new Object[0])) != null) {
                Method getMBeanServerMethod = mbeanFactory.getClass().getMethod("getMBeanServer", new Class[0]);
                servers.add((MBeanServer)getMBeanServerMethod.invoke(mbeanFactory, new Object[0]));
            }
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(INTERNAL_ERROR_MSG, ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(INTERNAL_ERROR_MSG, ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(INTERNAL_ERROR_MSG, ex);
        }
    }

    class WebsphereServerHandle
    extends ServerHandle {
        public WebsphereServerHandle(String pVersion, Map<String, String> pExtrainfo) {
            super("IBM", "websphere", pVersion, pExtrainfo);
        }

        @Override
        public ObjectName registerMBeanAtServer(MBeanServer pServer, Object pMBean, String pName) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException, MalformedObjectNameException {
            if (WebsphereDetector.this.isWebsphere6 && pMBean instanceof MBeanRegistration) {
                return pServer.registerMBean(pMBean, null).getObjectName();
            }
            return super.registerMBeanAtServer(pServer, pMBean, pName);
        }
    }
}

