/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ObjectType;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.Memory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.RuleBase;
import org.drools.core.phreak.PhreakAccumulateNode;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.FromNodeLeftTuple;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.accessor.Accumulator;
import org.drools.core.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.index.TupleList;

public class AccumulateNode
extends BetaNode {
    private static final long serialVersionUID = 510L;
    protected Accumulate accumulate;
    protected AlphaNodeFieldConstraint[] resultConstraints;
    protected BetaConstraints resultBinder;

    public AccumulateNode() {
    }

    public AccumulateNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, AlphaNodeFieldConstraint[] resultConstraints, BetaConstraints sourceBinder, BetaConstraints resultBinder, Accumulate accumulate, BuildContext context) {
        super(id, leftInput, rightInput, sourceBinder, context);
        this.setObjectCount(leftInput.getObjectCount() + 1);
        this.resultBinder = resultBinder;
        this.resultBinder.init(context, this.getType());
        this.resultConstraints = resultConstraints;
        this.accumulate = accumulate;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.addAccFunctionDeclarationsToLeftMask(context.getRuleBase(), leftInput, accumulate);
        this.hashcode = this.leftInput.hashCode() ^ this.rightInput.hashCode() ^ this.accumulate.hashCode() ^ this.resultBinder.hashCode() ^ Arrays.hashCode(this.resultConstraints);
    }

    private void addAccFunctionDeclarationsToLeftMask(RuleBase ruleBase, LeftTupleSource leftInput, Accumulate accumulate) {
        TypeDeclaration typeDeclaration;
        BitMask leftMask = this.getLeftInferredMask();
        ObjectType leftObjectType = leftInput.getObjectType();
        if (leftObjectType instanceof ClassObjectType && (typeDeclaration = ruleBase.getExactTypeDeclaration(((ClassObjectType)leftObjectType).getClassType())) != null && typeDeclaration.isPropertyReactive()) {
            List<String> accessibleProperties = typeDeclaration.getAccessibleProperties();
            for (Declaration decl : accumulate.getRequiredDeclarations()) {
                if (!leftObjectType.equals(decl.getPattern().getObjectType())) continue;
                leftMask = leftMask.setAll(decl.getPattern().getPositiveWatchMask(accessibleProperties));
            }
        }
        this.setLeftInferredMask(leftMask);
    }

    @Override
    protected ObjectType getObjectTypeForPropertyReactivity(LeftInputAdapterNode leftInput, Pattern pattern) {
        return pattern != null && this.isRightInputIsRiaNode() ? pattern.getObjectType() : leftInput.getParentObjectSource().getObjectTypeNode().getObjectType();
    }

    @Override
    public short getType() {
        return 211;
    }

    public Accumulate getAccumulate() {
        return this.accumulate;
    }

    public AlphaNodeFieldConstraint[] getResultConstraints() {
        return this.resultConstraints;
    }

    public BetaConstraints getResultBinder() {
        return this.resultBinder;
    }

    public InternalFactHandle createResultFactHandle(PropagationContext context, ReteEvaluator reteEvaluator, LeftTuple leftTuple, Object result) {
        InternalFactHandle handle = null;
        if (context.getReaderContext() != null) {
            handle = context.getReaderContext().createAccumulateHandle(context.getEntryPoint(), reteEvaluator, leftTuple, result, this.getId());
        }
        if (handle == null) {
            handle = reteEvaluator.createFactHandle(result, null, null);
        }
        return handle;
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
    }

    @Override
    protected int calculateHashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccumulateNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        AccumulateNode other = (AccumulateNode)object;
        return this.leftInput.getId() == other.leftInput.getId() && this.rightInput.getId() == other.rightInput.getId() && this.constraints.equals(other.constraints) && this.accumulate.equals(other.accumulate) && this.resultBinder.equals(other.resultBinder) && Arrays.equals(this.resultConstraints, other.resultConstraints);
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, ReteEvaluator reteEvaluator) {
        BetaMemory betaMemory = this.constraints.createBetaMemory(config, (short)211);
        AccumulateMemory memory = this.accumulate.isMultiFunction() ? new MultiAccumulateMemory(betaMemory, this.accumulate.getAccumulators()) : new SingleAccumulateMemory(betaMemory, this.accumulate.getAccumulators()[0]);
        memory.workingMemoryContext = this.accumulate.createWorkingMemoryContext();
        memory.resultsContext = this.resultBinder.createContext();
        return memory;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(factHandle, this, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return new FromNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        FromNodeLeftTuple peer = new FromNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public void retractRightTuple(RightTuple rightTuple, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        AccumulateMemory memory = (AccumulateMemory)reteEvaluator.getNodeMemory(this);
        BetaMemory bm = memory.getBetaMemory();
        rightTuple.setPropagationContext(pctx);
        this.doDeleteRightTuple(rightTuple, reteEvaluator, bm);
    }

    @Override
    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, ReteEvaluator reteEvaluator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            this.getRightInput().removeObjectSink(this);
            return true;
        }
        return false;
    }

    public static class GroupByContext
    implements BaseAccumulation {
        private PropagationContext propagationContext;
        private Map<Object, TupleList<AccumulateContextEntry>> groupsMap = new HashMap<Object, TupleList<AccumulateContextEntry>>();
        private TupleList<AccumulateContextEntry> lastTupleList;
        private TupleList<AccumulateContextEntry> toPropagateList;

        @Override
        public PropagationContext getPropagationContext() {
            return this.propagationContext;
        }

        @Override
        public void setPropagationContext(PropagationContext propagationContext) {
            this.propagationContext = propagationContext;
        }

        public Map<Object, TupleList<AccumulateContextEntry>> getGroups() {
            return this.groupsMap;
        }

        public TupleList<AccumulateContextEntry> getGroup(Object workingMemoryContext, Accumulate accumulate, Tuple leftTuple, Object key, ReteEvaluator reteEvaluator) {
            return this.groupsMap.computeIfAbsent(key, k -> {
                AccumulateContextEntry entry = new AccumulateContextEntry(key);
                entry.setFunctionContext(accumulate.init(workingMemoryContext, entry, accumulate.createFunctionContext(), leftTuple, reteEvaluator));
                PhreakAccumulateNode.initContext(workingMemoryContext, reteEvaluator, accumulate, leftTuple, entry);
                return new TupleList<AccumulateContextEntry>(entry);
            });
        }

        public void removeGroup(Object key) {
            this.groupsMap.remove(key);
        }

        public void moveToPropagateTupleList(TupleList<AccumulateContextEntry> list) {
            this.lastTupleList = list;
            if (list.getContext().isToPropagate()) {
                return;
            }
            list.setNext(this.toPropagateList);
            this.toPropagateList = list;
            list.getContext().setToPropagate(true);
        }

        public TupleList<AccumulateContextEntry> takeToPropagateList() {
            TupleList<AccumulateContextEntry> list = this.toPropagateList;
            this.toPropagateList = null;
            return list;
        }

        public void addMatchOnLastTupleList(LeftTuple match) {
            this.lastTupleList.add(match);
            this.lastTupleList.getContext().setEmpty(false);
        }

        public void clear() {
            for (TupleList<AccumulateContextEntry> list : this.groupsMap.values()) {
                Tuple tuple = list.getFirst();
                while (list.getFirst() != null) {
                    list.remove(tuple);
                    tuple.setContextObject(null);
                    tuple = list.getFirst();
                }
            }
            this.groupsMap.clear();
            this.toPropagateList = null;
            this.lastTupleList = null;
        }
    }

    public static class AccumulateContext
    extends AccumulateContextEntry
    implements BaseAccumulation {
        private PropagationContext propagationContext;

        public AccumulateContext() {
            super(null);
        }

        @Override
        public PropagationContext getPropagationContext() {
            return this.propagationContext;
        }

        @Override
        public void setPropagationContext(PropagationContext propagationContext) {
            this.propagationContext = propagationContext;
        }
    }

    public static class AccumulateContextEntry {
        private Object key;
        private InternalFactHandle resultFactHandle;
        private LeftTuple resultLeftTuple;
        private boolean propagated;
        private Object functionContext;
        private boolean toPropagate;
        private boolean empty = true;

        public AccumulateContextEntry(Object key) {
            this.key = key;
        }

        public InternalFactHandle getResultFactHandle() {
            return this.resultFactHandle;
        }

        public void setResultFactHandle(InternalFactHandle resultFactHandle) {
            this.resultFactHandle = resultFactHandle;
        }

        public LeftTuple getResultLeftTuple() {
            return this.resultLeftTuple;
        }

        public void setResultLeftTuple(LeftTuple resultLeftTuple) {
            this.resultLeftTuple = resultLeftTuple;
        }

        public boolean isPropagated() {
            return this.propagated;
        }

        public void setPropagated(boolean propagated) {
            this.propagated = propagated;
        }

        public boolean isToPropagate() {
            return this.toPropagate;
        }

        public void setToPropagate(boolean toPropagate) {
            this.toPropagate = toPropagate;
        }

        public Object getFunctionContext() {
            return this.functionContext;
        }

        public void setFunctionContext(Object context) {
            this.functionContext = context;
        }

        public Object getKey() {
            return this.key;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public void setEmpty(boolean empty) {
            this.empty = empty;
        }
    }

    public static interface BaseAccumulation {
        public PropagationContext getPropagationContext();

        public void setPropagationContext(PropagationContext var1);
    }

    public static class MultiAccumulateMemory
    extends AccumulateMemory {
        private final Accumulator[] accumulators;

        public MultiAccumulateMemory(BetaMemory betaMemory, Accumulator[] accumulators) {
            super(betaMemory);
            this.accumulators = accumulators;
        }

        @Override
        public void reset() {
            this.getBetaMemory().reset();
            this.workingMemoryContext = new Object[this.accumulators.length];
            for (int i = 0; i < this.accumulators.length; ++i) {
                ((Object[])this.workingMemoryContext)[i] = this.accumulators[i].createWorkingMemoryContext();
            }
        }
    }

    public static class SingleAccumulateMemory
    extends AccumulateMemory {
        private final Accumulator accumulator;

        public SingleAccumulateMemory(BetaMemory betaMemory, Accumulator accumulator) {
            super(betaMemory);
            this.accumulator = accumulator;
        }

        @Override
        public void reset() {
            this.getBetaMemory().reset();
            this.workingMemoryContext = this.accumulator.createWorkingMemoryContext();
        }
    }

    public static abstract class AccumulateMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements SegmentNodeMemory {
        public Object workingMemoryContext;
        private final BetaMemory betaMemory;
        public ContextEntry[] resultsContext;

        protected AccumulateMemory(BetaMemory betaMemory) {
            this.betaMemory = betaMemory;
        }

        public BetaMemory getBetaMemory() {
            return this.betaMemory;
        }

        @Override
        public short getNodeType() {
            return 211;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.betaMemory.getSegmentMemory();
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            this.betaMemory.setSegmentMemory(segmentMemory);
        }

        @Override
        public abstract void reset();

        @Override
        public long getNodePosMaskBit() {
            return this.betaMemory.getNodePosMaskBit();
        }

        @Override
        public void setNodePosMaskBit(long segmentPos) {
            this.betaMemory.setNodePosMaskBit(segmentPos);
        }

        @Override
        public void setNodeDirtyWithoutNotify() {
            this.betaMemory.setNodeDirtyWithoutNotify();
        }

        @Override
        public void setNodeCleanWithoutNotify() {
            this.betaMemory.setNodeCleanWithoutNotify();
        }
    }
}

