/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.net.InetSocketAddress;
import java.util.Objects;
import org.opennms.core.ipc.sink.api.AggregationPolicy;
import org.opennms.core.ipc.sink.api.AsyncPolicy;
import org.opennms.core.ipc.sink.xml.AbstractXmlSinkModule;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.syslogd.api.SyslogConnection;
import org.opennms.netmgt.syslogd.api.SyslogMessageDTO;
import org.opennms.netmgt.syslogd.api.SyslogMessageLogDTO;

public class SyslogSinkModule
extends AbstractXmlSinkModule<SyslogConnection, SyslogMessageLogDTO> {
    public static final String MODULE_ID = "Syslog";
    private final SyslogdConfig config;
    private final DistPollerDao distPollerDao;

    public SyslogSinkModule(SyslogdConfig config, DistPollerDao distPollerDao) {
        super(SyslogMessageLogDTO.class);
        this.config = Objects.requireNonNull(config);
        this.distPollerDao = Objects.requireNonNull(distPollerDao);
    }

    public String getId() {
        return MODULE_ID;
    }

    public int getNumConsumerThreads() {
        return this.config.getNumThreads();
    }

    public AggregationPolicy<SyslogConnection, SyslogMessageLogDTO, SyslogMessageLogDTO> getAggregationPolicy() {
        final String systemId = this.distPollerDao.whoami().getId();
        final String systemLocation = this.distPollerDao.whoami().getLocation();
        return new AggregationPolicy<SyslogConnection, SyslogMessageLogDTO, SyslogMessageLogDTO>(){

            public int getCompletionSize() {
                return SyslogSinkModule.this.config.getBatchSize();
            }

            public int getCompletionIntervalMs() {
                return SyslogSinkModule.this.config.getBatchIntervalMs();
            }

            public Object key(SyslogConnection syslogConnection) {
                return syslogConnection.getSource();
            }

            public SyslogMessageLogDTO aggregate(SyslogMessageLogDTO accumulator, SyslogConnection connection) {
                if (accumulator == null) {
                    accumulator = new SyslogMessageLogDTO(systemLocation, systemId, connection.getSource());
                }
                SyslogMessageDTO messageDTO = new SyslogMessageDTO(connection.getBuffer());
                accumulator.getMessages().add(messageDTO);
                return accumulator;
            }

            public SyslogMessageLogDTO build(SyslogMessageLogDTO accumulator) {
                return accumulator;
            }
        };
    }

    public AsyncPolicy getAsyncPolicy() {
        return new AsyncPolicy(){

            public int getQueueSize() {
                return SyslogSinkModule.this.config.getQueueSize();
            }

            public int getNumThreads() {
                return SyslogSinkModule.this.config.getNumThreads();
            }

            public boolean isBlockWhenFull() {
                return true;
            }
        };
    }

    public SyslogConnection unmarshalSingleMessage(byte[] bytes) {
        SyslogMessageLogDTO syslogMessageLogDTO = (SyslogMessageLogDTO)this.unmarshal(bytes);
        SyslogMessageDTO syslogMessageDTO = syslogMessageLogDTO.getMessages().get(0);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(syslogMessageLogDTO.getSourceAddress(), syslogMessageLogDTO.getSourcePort());
        return new SyslogConnection(inetSocketAddress, syslogMessageDTO.getBytes());
    }

    public SyslogMessageLogDTO toMessageLog(SyslogConnection ... connections) {
        String systemId = this.distPollerDao.whoami().getId();
        String systemLocation = this.distPollerDao.whoami().getLocation();
        if (connections.length < 1) {
            throw new IllegalArgumentException("One or more connection are required.");
        }
        SyslogMessageLogDTO messageLog = new SyslogMessageLogDTO(systemLocation, systemId, connections[0].getSource());
        for (SyslogConnection connection : connections) {
            SyslogMessageDTO messageDTO = new SyslogMessageDTO(connection.getBuffer());
            messageLog.getMessages().add(messageDTO);
        }
        return messageLog;
    }

    public int hashCode() {
        return Objects.hash(MODULE_ID);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return ((Object)((Object)this)).getClass() == obj.getClass();
    }
}

