/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.service.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import org.opennms.features.config.exception.ConfigConversionException;

public class ConfigConvertUtil {
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.KebabCaseStrategy());

    private ConfigConvertUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static <E> E jsonToObject(String jsonStr, Class<E> entityClass) {
        try {
            return (E)mapper.readValue(jsonStr, entityClass);
        }
        catch (JsonProcessingException e) {
            throw new ConfigConversionException("Fail to convert json to object. ", (Throwable)e);
        }
    }

    public static String objectToJson(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new ConfigConversionException("Fail to convert object to json. ", (Throwable)e);
        }
    }

    static {
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
    }
}

