/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.service.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.features.config.exception.ConfigRuntimeException;

public class BeanFieldCopyUtil {
    private BeanFieldCopyUtil() {
    }

    public static <E> void copyFields(E source, E target) {
        if (source == null || target == null) {
            throw new ConfigRuntimeException("Source or target cannot be null.");
        }
        Iterable<Field> allFields = BeanFieldCopyUtil.getAllFields(source.getClass());
        allFields.forEach(field -> {
            try {
                BeanFieldCopyUtil.copyValue(source, target, field);
            }
            catch (IllegalAccessException e) {
                throw new ConfigRuntimeException("Failed to copy field value.", (Throwable)e);
            }
        });
    }

    private static <E> void copyValue(E source, E target, Field field) throws IllegalAccessException {
        field.setAccessible(true);
        field.set(target, field.get(source));
    }

    public static Iterable<Field> getAllFields(Class<?> sourceClass) {
        return BeanFieldCopyUtil.getAllFields(sourceClass, null);
    }

    public static Iterable<Field> getAllFields(Class<?> sourceClass, Class<?> currentParentClass) {
        List<Field> currentClassFields = Arrays.stream(sourceClass.getDeclaredFields()).filter(f -> !Modifier.isFinal(f.getModifiers()) && !Modifier.isStatic(f.getModifiers())).collect(Collectors.toList());
        Class<?> parentClass = sourceClass.getSuperclass();
        if (parentClass != null && !parentClass.equals(currentParentClass)) {
            List parentClassFields = (List)BeanFieldCopyUtil.getAllFields(parentClass, currentParentClass);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }
}

