/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.service.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.opennms.features.config.exception.ConfigNotFoundException;
import org.opennms.features.config.exception.ValidationException;
import org.opennms.features.config.service.api.CmJaxbConfigDao;
import org.opennms.features.config.service.api.ConfigUpdateInfo;
import org.opennms.features.config.service.api.ConfigurationManagerService;
import org.opennms.features.config.service.api.EventType;
import org.opennms.features.config.service.api.JsonAsString;
import org.opennms.features.config.service.util.BeanFieldCopyUtil;
import org.opennms.features.config.service.util.ConfigConvertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCmJaxbConfigDao<E>
implements CmJaxbConfigDao {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCmJaxbConfigDao.class);
    @Autowired
    protected ConfigurationManagerService configurationManagerService;
    private Class<E> entityClass;
    private String description;
    private ConcurrentHashMap<String, E> lastKnownEntityMap = new ConcurrentHashMap();

    protected AbstractCmJaxbConfigDao(Class<E> entityClass, String description) {
        this.entityClass = Objects.requireNonNull(entityClass);
        this.description = Objects.requireNonNull(description);
    }

    @PostConstruct
    public void postConstruct() {
        Set configIds = this.configurationManagerService.getConfigIds(this.getConfigName());
        configIds.forEach(configId -> this.addOnReloadedCallback((String)configId, this.getUpdateCallback()));
        Consumer validateCallback = this.getValidationCallback();
        if (validateCallback != null) {
            this.addValidationCallback(validateCallback);
        }
    }

    public E loadConfig() {
        return this.loadConfig(this.getDefaultConfigId());
    }

    public E loadConfig(String configId) {
        long startTime = System.currentTimeMillis();
        LOG.debug("Loading {} configuration from {}", (Object)this.description, (Object)configId);
        Optional<Object> configOptional = this.configurationManagerService.getJSONStrConfiguration(this.getConfigName(), configId).map(s -> ConfigConvertUtil.jsonToObject(s, this.entityClass));
        if (configOptional.isEmpty()) {
            throw new ConfigNotFoundException("NOT_FOUND: configName: " + this.getConfigName() + " configId: " + configId);
        }
        Object config = configOptional.get();
        long endTime = System.currentTimeMillis();
        LOG.info("Loaded {} in {} ms", (Object)this.getDescription(), (Object)(endTime - startTime));
        return (E)this.lastKnownEntityMap.compute(configId, (k, v) -> {
            if (v != null) {
                BeanFieldCopyUtil.copyFields(config, v);
                return v;
            }
            return config;
        });
    }

    public E getConfig(String configId) {
        E config = this.lastKnownEntityMap.get(configId);
        if (config != null) {
            return config;
        }
        return this.loadConfig(configId);
    }

    public void updateConfig(String configId, E config) throws ValidationException {
        this.updateConfig(configId, ConfigConvertUtil.objectToJson(config));
    }

    public void updateConfig(String configId, String jsonConfigString) throws ValidationException {
        this.updateConfig(configId, jsonConfigString, false);
    }

    public void updateConfig(String configId, String jsonConfigString, boolean isReplace) throws ValidationException {
        this.configurationManagerService.updateConfiguration(this.getConfigName(), configId, new JsonAsString(jsonConfigString), isReplace);
    }

    public void updateConfig(String configJsonStr) throws ValidationException {
        this.updateConfig(this.getDefaultConfigId(), configJsonStr);
    }

    public void updateConfig(E config) throws ValidationException {
        this.updateConfig(this.getDefaultConfigId(), config);
    }

    public String getDescription() {
        return this.description;
    }

    public void addOnReloadedCallback(String configId, Consumer<ConfigUpdateInfo> callback) {
        Objects.requireNonNull(callback);
        this.configurationManagerService.registerEventHandler(EventType.UPDATE, new ConfigUpdateInfo(this.getConfigName(), configId), callback);
    }

    public void addValidationCallback(Consumer<ConfigUpdateInfo> callback) {
        Objects.requireNonNull(callback);
        this.configurationManagerService.registerEventHandler(EventType.VALIDATE, new ConfigUpdateInfo(this.getConfigName()), callback);
    }
}

