///
/// Licensed to The OpenNMS Group, Inc (TOG) under one or more
/// contributor license agreements.  See the LICENSE.md file
/// distributed with this work for additional information
/// regarding copyright ownership.
///
/// TOG licenses this file to You under the GNU Affero General
/// Public License Version 3 (the "License") or (at your option)
/// any later version.  You may not use this file except in
/// compliance with the License.  You may obtain a copy of the
/// License at:
///
///      https://www.gnu.org/licenses/agpl-3.0.txt
///
/// Unless required by applicable law or agreed to in writing,
/// software distributed under the License is distributed on an
/// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
/// either express or implied.  See the License for the specific
/// language governing permissions and limitations under the
/// License.
///

export const advancedKeys = [
  {
    id: 22,
    name: 'cimTimeout',
    _text: 'cimTimeout',
    hint: ''
  },
  {
    id: 18,
    name: 'hostSystemServices',
    _text: 'hostSystemServices',
    hint: ''
  },
  {
    id: 1,
    name: 'importIPv4Only',
    _text: 'importIPv4Only',
    hint: ''
  },
  {
    id: 2,
    name: 'importIPv6Only',
    _text: 'importIPv6Only',
    hint: ''
  },
  {
    id: 3,
    name: 'topologyNetworks',
    _text: 'topologyNetworks',
    hint: ''
  },
  {
    id: 4,
    name: 'topologyDatastores',
    _text: 'topologyDatastores',
    hint: ''
  },
  {
    id: 5,
    name: 'topologyPortGroups',
    _text: 'topologyPortGroups',
    hint: ''
  },
  {
    id: 6,
    name: 'importVMPoweredOn',
    _text: 'importVMPoweredOn',
    hint: ''
  },
  {
    id: 7,
    name: 'importVMPoweredOff',
    _text: 'importVMPoweredOff',
    hint: ''
  },
  {
    id: 8,
    name: 'importVMSuspended',
    _text: 'importVMSuspended',
    hint: ''
  },
  {
    id: 9,
    name: 'importVMAll',
    _text: 'importVMAll',
    hint: ''
  },
  {
    id: 10,
    name: 'importVMOnly',
    _text: 'importVMOnly',
    hint: ''
  },
  {
    id: 11,
    name: 'importHostPoweredOn',
    _text: 'importHostPoweredOn',
    hint: ''
  },
  {
    id: 12,
    name: 'importHostPoweredOff',
    _text: 'importHostPoweredOff',
    hint: ''
  },
  {
    id: 13,
    name: 'importHostStandBy',
    _text: 'importHostStandBy',
    hint: ''
  },
  {
    id: 14,
    name: 'importHostUnknown',
    _text: 'importHostUnknown',
    hint: ''
  },
  {
    id: 15,
    name: 'importHostAll',
    _text: 'importHostAll',
    hint: ''
  },
  {
    id: 16,
    name: 'importHostOnly',
    _text: 'importHostOnly',
    hint: ''
  },
  {
    id: 21,
    name: 'timeout',
    _text: 'timeout',
    hint: ''
  },
  {
    id: 17,
    name: 'virtualMachineServices',
    _text: 'virtualMachineServices'
  }
]

export const dnsKeys = [
  {
    id: 1,
    name: 'expression',
    _text: 'expression',
    hint: 'Filter records by regular expression'
  },
  { id: 2, name: 'location', _text: 'location', hint: 'Monitoring location for all nodes' }
]

export const openDaylightKeys = [
  {
    id: 1,
    name: 'host',
    _text: 'host',
    hint: 'ODL Controller Host'
  },
  { id: 2, name: 'port', _text: 'port', hint: 'ODL Controller Port' }
]

export const prisKeys = [
  {
    id: 1,
    name: 'source',
    _text: 'source',
    hint: 'Inventory source ID'
  },
  { id: 2, name: 'mapper', _text: 'mapper', hint: 'Mapper script to apply' }
]

export const aciKeys = [
  {
    id: 1,
    name: 'cluster-name',
    _text: 'cluster-name',
    hint: 'Cluster to import'
  },
  {
    id: 1,
    name: 'hostname',
    _text: 'hostname',
    hint: 'ACI Controller Host'
  },
  {
    id: 1,
    name: 'username',
    _text: 'username',
    hint: 'ACI authentication username'
  },
  {
    id: 1,
    name: 'password',
    _text: 'password',
    hint: 'ACI authentication password'
  },
  {
    id: 1,
    name: 'apic-url',
    _text: 'apic-url',
    hint: 'ACI APIC URL'
  },
  {
    id: 1,
    name: 'location',
    _text: 'location',
    hint: 'Monitoring location for all nodes'
  }
]

export const zabbixKeys = []
