<%--

    Licensed to The OpenNMS Group, Inc (TOG) under one or more
    contributor license agreements.  See the LICENSE.md file
    distributed with this work for additional information
    regarding copyright ownership.

    TOG licenses this file to You under the GNU Affero General
    Public License Version 3 (the "License") or (at your option)
    any later version.  You may not use this file except in
    compliance with the License.  You may obtain a copy of the
    License at:

         https://www.gnu.org/licenses/agpl-3.0.txt

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
    either express or implied.  See the License for the specific
    language governing permissions and limitations under the
    License.

--%>
<%@page language="java"
	contentType="text/html"
	session="true"
	import="java.util.*,
		org.opennms.web.element.NetworkElementFactory,
		org.opennms.web.admin.nodeManagement.*,
		org.opennms.core.utils.WebSecurityUtils
	"
%>

<%!
    int interfaceIndex;
    int serviceIndex;
%>

<%
    HttpSession userSession = request.getSession(false);
    List<ManagedInterface> interfaces = null;
    Integer lineItems= new Integer(0);
    
    //EventConfFactory eventFactory = EventConfFactory.getInstance();
    
    interfaceIndex = 0;
    serviceIndex = 0;
    
    if (userSession == null) {
	throw new ServletException("User session is null");
    }

    interfaces = (List<ManagedInterface>) userSession.getAttribute("interfaces.nodemanagement");
    if (interfaces == null) {
	throw new ServletException("Session attribute "
				   + "interfaces.nodemanagement is null");
    } else if (interfaces.size() < 1) {
    	throw new NoManagedInterfacesException("element/nodeList.htm");
    }
    lineItems = (Integer) userSession.getAttribute("lineItems.nodemanagement");
    if (lineItems == null) {
	throw new ServletException("Session attribute "
				   + "lineItems.nodemanagement is null");
    }
%>

<%@ page import="org.opennms.web.utils.Bootstrap" %>
<% Bootstrap.with(pageContext)
          .headTitle("Node Management")
          .headTitle("Admin")
          .breadcrumb("Admin", "admin/index.jsp")
          .breadcrumb("Node Management")
          .build(request);
%>
<jsp:directive.include file="/includes/bootstrap.jsp" />

<script type="text/javascript" >

  function applyChanges()
  {
      return confirm("Are you sure you want to proceed? It may take several minutes to update the database based on the changes made.");
  }
  
  function cancel()
  {
      document.manageAll.action="admin/nodemanagement/index.jsp";
      document.manageAll.submit();
  }
  
  function checkAll()
  {
      for (var c = 0; c < document.manageAll.elements.length; c++)
      {  
          if (document.manageAll.elements[c].type == "checkbox")
          {
              document.manageAll.elements[c].checked = true;
          }
      }
  }
  
  function uncheckAll()
  {
      for (var c = 0; c < document.manageAll.elements.length; c++)
      {  
          if (document.manageAll.elements[c].type == "checkbox")
          {
              
              document.manageAll.elements[c].checked = false;
          }
      }
  }
  
  function updateServices(interfaceIndex, serviceIndexes)
  {
      for (var i = 0; i < serviceIndexes.length; i++)
      {
          document.manageAll.serviceCheck[serviceIndexes[i]].checked = document.manageAll.interfaceCheck[interfaceIndex].checked;
      }
  }
  
  function verifyManagedInterface(interfaceIndex, serviceIndex)
  {
      //if the service is currently unmanged then the user is trying to manage it,
      //but we need to make sure its interface is managed before we let the service be managed
      if (!document.manageAll.interfaceCheck[interfaceIndex].checked)
      {
          if (document.manageAll.serviceCheck[serviceIndex].checked)
          {
              alert("The interface that this service is on is not managed. Please manage the interface to manage the service.");
              document.manageAll.serviceCheck[serviceIndex].checked = false;
              return false;
          }
      }
      
      return true;
  }

</script>

<%
        int halfway = 0;
        int midCount = 0;
        int midInterfaceIndex = 0;
        String nodeLabel = null;
  
        if (lineItems.intValue() > 0)
        {
                ManagedInterface firstInterface = interfaces.get(0);
                nodeLabel = NetworkElementFactory.getInstance(getServletContext()).getNodeLabel(firstInterface.getNodeid());
    
                if ( interfaces.size() == 1)
                { 
                        midInterfaceIndex = 1;
                }
                else
                {
                        halfway = lineItems.intValue()/2;
                        for (int interfaceCount = 0; (interfaceCount < interfaces.size()) && (midCount < halfway); interfaceCount++)
                        {
                                if (midCount < halfway)
                                {
                                        midCount++; //one row for each interface
                                        ManagedInterface curInterface = (ManagedInterface)interfaces.get(interfaceCount);
                                        midCount += curInterface.getServiceCount();
                                }
                                else 
                                {
                                        midInterfaceIndex = interfaceCount;
                                        break;
                                }
                        }
                }

                if (midInterfaceIndex < 1)
                        midInterfaceIndex = interfaces.size();
        }
%>

<h3>Node: <%=WebSecurityUtils.sanitizeString(nodeLabel)%></h3>

<hr/>
    
<form method="post" name="manageAll" action="admin/manageNode" onsubmit="return applyChanges();">

<div class="card">
  <div class="card-header">
    <span>Manage and Unmanage Interfaces and Services</span>
  </div>
  <div class="card-body">
    <!--
    <p>
      The two tables below represent each managed and unmanged interface,
      and service combination.  The 'Managed' column indicates if the
      interface or service is managed or not, with checked rows meaning
      the interface or service is managed, and unchecked meaning not managed.
      Each different interface has a dark grey row and no service column,
      and each service on that interface is listed below on light grey rows.
    </p>

    <p>
      Managing or Unmanaging an interface will automatically mark each
      service on that interface as managed or unmanaged accordingly.  A
      service cannot be managed if its interface is not managed.
    </p>
    -->

    <p>
      The table below represent each managed and unmanged interface,
      and service combination.  The 'Managed' column indicates if the
      service is managed or not on the interface, with checked rows meaning
      the interface/service is managed, and unchecked meaning not managed.
    </p>

    <%
      ManagedInterface firstInterface = (ManagedInterface) interfaces.get(0);
      int nodeId = firstInterface.getNodeid();
    %>

    <input type="hidden" name="node" value="<%= nodeId %>"/>

    <div class="form-group">
      <input type="submit" class="btn btn-secondary" value="Apply Changes"/>
      <input type="button" class="btn btn-secondary" value="Cancel" onclick="cancel()"/>
      <input type="button" class="btn btn-secondary" value="Select All" onclick="checkAll()"/>
      <input type="button" class="btn btn-secondary" value="Unselect All" onclick="uncheckAll()"/>
      <input type="reset" class="btn btn-secondary" />
    </div>

    <div class="row">
    <% if (interfaces.size() > 0) { %>
      <div class="col-md-6">
        <table class="table table-sm">
          <tr>
            <th class="text-center" width="5%">Managed</th>
            <th class="text-center" width="10%">Interface</th>
            <th class="text-center" width="10%">Service</th>
          </tr>

          <%=buildManageTableRows(interfaces, 0, midInterfaceIndex)%>
        </table>
      </div>
    <% } /*end if*/ %>

    <%-- See if there is a second column to draw --%>
    <% if (midInterfaceIndex < interfaces.size()) { %>
      <div class="col-md-6">
        <table class="table table-sm">
          <tr>
            <th class="text-center" width="5%">Managed</th>
            <th class="text-center" width="10%">Interface</th>
            <th class="text-center" width="10%">Service</th>
          </tr>

          <%=buildManageTableRows(interfaces, midInterfaceIndex, interfaces.size())%>
        </table>
      </div>
    <% } /*end if */ %>
    </div>

    <div class="form-group">
      <input type="submit" class="btn btn-secondary" value="Apply Changes"/>
      <input type="button" class="btn btn-secondary" value="Cancel" onclick="cancel()"/>
      <input type="button" class="btn btn-secondary" value="Select All" onclick="checkAll()"/>
      <input type="button" class="btn btn-secondary" value="Unselect All" onclick="uncheckAll()"/>
      <input type="reset" class="btn btn-secondary" />
    </div>
  </div> <!-- card-body -->
</div> <!-- panel -->

</form>

<jsp:include page="/includes/bootstrap-footer.jsp" flush="true"/>

<%!
      public String buildManageTableRows(List<ManagedInterface> interfaces, int start, int stop)
      	throws java.sql.SQLException
      {
          StringBuffer rows = new StringBuffer();
          
          for (int i = start; i < stop; i++)
          {
                
                ManagedInterface curInterface = interfaces.get(i);
		String intKey = curInterface.getNodeid() + "-" + curInterface.getAddress();
                StringBuffer serviceArray = new StringBuffer("[");
                String prepend = "";
                for (int serviceCount = 0; serviceCount < curInterface.getServiceCount(); serviceCount++)
                {
                    serviceArray.append(prepend).append(serviceIndex+serviceCount);
                    prepend = ",";
                }
                serviceArray.append("]");

                rows.append(buildInterfaceRow(intKey, 
                                              interfaceIndex, 
                                              serviceArray.toString(), 
                                              (curInterface.getStatus().equals("managed") ? "checked" : ""),
                                              curInterface.getAddress()));
                  
                List<ManagedService> interfaceServices = curInterface.getServices();
                for (int k = 0; k < interfaceServices.size(); k++) 
                {
                     ManagedService curService = interfaceServices.get(k);
                     String serviceKey = curInterface.getNodeid() + "-" + curInterface.getAddress() + "-" + curService.getId();
                     rows.append(buildServiceRow(serviceKey,
                                                 interfaceIndex,
                                                 serviceIndex,
                                                 (curService.getStatus().equals("managed") ? "checked" : ""),
                                                 curInterface.getAddress(),
                                                 curService.getName()));
                     serviceIndex++;
                
                } /*end k for */
                
                interfaceIndex++;
                
          } /* end i for */
          
          return rows.toString();
      }
      
      public String buildInterfaceRow(String key, int interfaceIndex, String serviceArray, String status, String address)
      {
          StringBuffer row = new StringBuffer( "<tr>");
          /*
          row.append("<td class=\"standardheaderplain\" width=\"5%\" align=\"center\">");
          row.append("<input type=\"checkbox\" name=\"interfaceCheck\" value=\"").append(key).append("\" onclick=\"javascript:updateServices(" + interfaceIndex + ", " + serviceArray + ")\" ").append(status).append(" >");
          row.append("</td>").append("\n");
          row.append("</td>").append("\n");
          row.append("<td class=\"standardheaderplain\" width=\"10%\" align=\"center\">");
          row.append(address);
          row.append("</td>").append("\n");
          row.append("<td class=\"standardheaderplain\" width=\"10%\" align=\"center\">").append("&nbsp;").append("</td></tr>").append("\n");
          */ 
          row.append("<input type=\"hidden\" name=\"interfaceCheck\" value=\"").append(key).append("\" onclick=\"javascript:updateServices(" + interfaceIndex + ", " + serviceArray + ")\" ").append(status).append(" >");
          return row.toString();
      }
      
      public String buildServiceRow(String key, int interfaceIndex, int serviceIndex, String status, String address, String service)
      {
          StringBuffer row = new StringBuffer( "<tr>");
          
          row.append("<td class=\"text-center\" width=\"5%\">");
          row.append("<input type=\"checkbox\" name=\"serviceCheck\" value=\"").append(key).append("\" onclick=\"javascript:verifyManagedInterface(" + interfaceIndex + ", " + serviceIndex + ")\" ").append(status).append(" >");
          row.append("</td>").append("\n");
          row.append("<td class=\"text-center\" width=\"10%\">").append(address).append("</td>").append("\n");
          row.append("<td class=\"text-center\" width=\"10%\">").append(service).append("</td></tr>").append("\n");
          
          return row.toString();
      }
%>
