/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.0.3-b01-fcs 
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a> 
// Any modifications to this file will be lost upon recompilation of the source schema. 
// Generated on: 2009.01.29 at 01:15:48 PM EST 
//


package org.opennms.netmgt.provision.persist.requisition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import org.apache.commons.lang.builder.CompareToBuilder;


/**
 * <p>RequisitionMonitoredService class.</p>
 *
 * @author ranger
 * @version $Id: $
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name="", propOrder = { "m_categories", "m_metaData" })
@XmlRootElement(name="monitored-service")
public class RequisitionMonitoredService implements Comparable<RequisitionMonitoredService> {

    @XmlElement(name="category")
    protected List<RequisitionCategory> m_categories = new ArrayList<RequisitionCategory>();

    @XmlElement(name="meta-data")
    protected List<RequisitionMetaData> m_metaData = new ArrayList<>();
    
    @XmlAttribute(name="service-name", required=true)
    protected String m_serviceName;

    /**
     * <p>Constructor for RequisitionMonitoredService.</p>
     */
    public RequisitionMonitoredService() {
    }
    
    /**
     * <p>Constructor for RequisitionMonitoredService.</p>
     *
     * @param serviceName a {@link java.lang.String} object.
     */
    public RequisitionMonitoredService(String serviceName) {
        m_serviceName = serviceName;
    }

    /**
     * <p>getCategoryCount</p>
     *
     * @return a int.
     */
    @XmlTransient
    public int getCategoryCount() {
        return (m_categories == null) ? 0 : m_categories.size();
    }

    /* backwards compatibility with ModelImport */
    /**
     * <p>getCategory</p>
     *
     * @return an array of {@link org.opennms.netmgt.provision.persist.requisition.RequisitionCategory} objects.
     */
    @XmlTransient
    public RequisitionCategory[] getCategory() {
        return m_categories.toArray(new RequisitionCategory[] {});
    }

    /**
     * <p>getCategories</p>
     *
     * @return a {@link java.util.List} object.
     */
    public List<RequisitionCategory> getCategories() {
        if (m_categories == null) {
            m_categories = new ArrayList<>();
        }
        return m_categories;
    }

    /**
     * <p>setCategories</p>
     *
     * @param categories a {@link java.util.List} object.
     */
    public void setCategories(List<RequisitionCategory> categories) {
        m_categories = categories;
    }

    /**
     * <p>deleteCategory</p>
     *
     * @param category a {@link org.opennms.netmgt.provision.persist.requisition.RequisitionCategory} object.
     */
    public void deleteCategory(RequisitionCategory category) {
        if (m_categories != null) {
            Iterator<RequisitionCategory> i = m_categories.iterator();
            while (i.hasNext()) {
                RequisitionCategory cat = i.next();
                if (cat.getName().equals(category.getName())) {
                    i.remove();
                    break;
                }
            }
        }
    }

    /**
     * <p>deleteCategory</p>
     *
     * @param category a {@link java.lang.String} object.
     */
    public void deleteCategory(String category) {
        if (m_categories != null) {
            Iterator<RequisitionCategory> i = m_categories.iterator();
            while (i.hasNext()) {
                RequisitionCategory cat = i.next();
                if (cat.getName().equals(category)) {
                    i.remove();
                    break;
                }
            }
        }
    }

    /**
     * <p>insertCategory</p>
     *
     * @param category a {@link org.opennms.netmgt.provision.persist.requisition.RequisitionCategory} object.
     */
    public void insertCategory(RequisitionCategory category) {
        Iterator<RequisitionCategory> iterator = m_categories.iterator();
        while (iterator.hasNext()) {
            RequisitionCategory existing = iterator.next();
            if (existing.getName().equals(category.getName())) {
                iterator.remove();
            }
        }
        m_categories.add(0, category);
    }

    public List<RequisitionMetaData> getMetaData() {
        return m_metaData;
    }

    public void setMetaData(List<RequisitionMetaData> metaData) {
        m_metaData = metaData;
    }

    /**
     * <p>getServiceName</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getServiceName() {
        return m_serviceName;
    }

    /**
     * <p>setServiceName</p>
     *
     * @param value a {@link java.lang.String} object.
     */
    public void setServiceName(String value) {
        m_serviceName = value;
    }

    public void validate() throws ValidationException {
        if (m_serviceName == null) {
            throw new ValidationException("Requisition monitored-service 'service-name' is a required attribute!");
        }
        if (m_categories != null) {
            for (final RequisitionCategory cat : m_categories) {
                cat.validate();
            }
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(m_categories, m_metaData, m_serviceName);
    }

    @Override
    public boolean equals(final Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;
        if (!(obj instanceof RequisitionMonitoredService)) return false;
        final RequisitionMonitoredService that = (RequisitionMonitoredService) obj;
        return Objects.deepEquals(this.m_categories, that.m_categories)
                && Objects.deepEquals(this.m_metaData, that.m_metaData)
                && Objects.equals(this.m_serviceName, that.m_serviceName);
    }

    @Override
    public String toString() {
        return "RequisitionMonitoredService [categories=" + m_categories
                + ", metaData=" + m_metaData
                + ", serviceName=" + m_serviceName + "]";
    }

    @Override
    public int compareTo(final RequisitionMonitoredService other) {
        return new CompareToBuilder()
            .append(m_serviceName, other.m_serviceName)
            .append(m_categories, other.m_categories)
            .append(m_metaData, other.m_metaData)
            .toComparison();
    }
}
