/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.flows.classification.ClassificationEngine;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncReloadingClassificationEngine
implements ClassificationEngine {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncReloadingClassificationEngine.class);
    private final ClassificationEngine delegate;
    private final ExecutorService executorService = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), runnable -> new Thread(runnable, "AsyncReloadingClassificationEngine"));
    private State state = State.READY;
    private Throwable reloadException;
    private Future<?> reloadFuture;

    public AsyncReloadingClassificationEngine(ClassificationEngine delegate) {
        this.delegate = delegate;
        this.reload();
    }

    private void setState(State newState) {
        this.state = newState;
        this.notifyAll();
    }

    private void waitUntilReadyOrFailed() {
        while (true) {
            switch (this.state) {
                case READY: {
                    return;
                }
                case FAILED: {
                    throw new RuntimeException("classification engine can not be used because last reload failed", this.reloadException);
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void doReload() {
        try {
            LOG.debug("reload classification engine");
            this.delegate.reload();
            LOG.debug("classification engine reloaded");
            this.onReloadSucceeded();
        }
        catch (InterruptedException e) {
            LOG.debug("reload was interrupted");
        }
        catch (Throwable e) {
            LOG.error("reload of classification engine failed", e);
            this.onReloadFailed(e);
        }
    }

    private synchronized void onReloadSucceeded() {
        this.setState(State.READY);
    }

    private synchronized void onReloadFailed(Throwable e) {
        this.reloadException = e;
        this.setState(State.FAILED);
    }

    public synchronized String classify(ClassificationRequest classificationRequest) {
        this.waitUntilReadyOrFailed();
        return this.delegate.classify(classificationRequest);
    }

    public synchronized List<Rule> getInvalidRules() {
        this.waitUntilReadyOrFailed();
        return this.delegate.getInvalidRules();
    }

    public synchronized void reload() {
        switch (this.state) {
            case READY: 
            case FAILED: {
                try {
                    this.reloadFuture = this.executorService.submit(this::doReload);
                    this.setState(State.RELOADING);
                }
                catch (Throwable t) {
                    LOG.error("could not submit reload task", t);
                    this.reloadException = t;
                    this.setState(State.FAILED);
                }
                break;
            }
            case RELOADING: {
                this.reloadFuture.cancel(true);
                this.reloadFuture = this.executorService.submit(this::doReload);
            }
        }
    }

    public void addClassificationRulesReloadedListener(ClassificationEngine.ClassificationRulesReloadedListener classificationRulesReloadedListener) {
        this.delegate.addClassificationRulesReloadedListener(classificationRulesReloadedListener);
    }

    public void removeClassificationRulesReloadedListener(ClassificationEngine.ClassificationRulesReloadedListener classificationRulesReloadedListener) {
        this.delegate.removeClassificationRulesReloadedListener(classificationRulesReloadedListener);
    }

    private static enum State {
        READY,
        RELOADING,
        FAILED;

    }
}

