/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.vaadin.extender.internal.servlet;

import com.vaadin.server.BootstrapFragmentResponse;
import com.vaadin.server.BootstrapListener;
import com.vaadin.server.BootstrapPageResponse;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceException;
import com.vaadin.server.SessionDestroyEvent;
import com.vaadin.server.SessionDestroyListener;
import com.vaadin.server.SessionInitEvent;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.UIProvider;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import java.util.Objects;
import org.opennms.vaadin.extender.SessionListenerRepository;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaadinOSGiServlet
extends VaadinServlet {
    private final UIProvider m_provider;
    private final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final BundleContext m_context;

    public VaadinOSGiServlet(UIProvider uiProvider, BundleContext bundleContext) {
        this.m_provider = Objects.requireNonNull(uiProvider);
        this.m_context = bundleContext;
    }

    protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        VaadinServletService service = super.createServletService(deploymentConfiguration);
        service.addSessionInitListener(new SessionInitListener(){

            public void sessionInit(SessionInitEvent event) throws ServiceException {
                VaadinSession session = event.getSession();
                if (session.getUIProviders().isEmpty() || !session.getUIProviders().contains(VaadinOSGiServlet.this.m_provider)) {
                    session.addUIProvider(VaadinOSGiServlet.this.m_provider);
                }
            }
        });
        service.addSessionDestroyListener(new SessionDestroyListener(){

            public void sessionDestroy(SessionDestroyEvent event) {
                VaadinSession session = event.getSession();
                if (session.getUIProviders().contains(VaadinOSGiServlet.this.m_provider)) {
                    session.removeUIProvider(VaadinOSGiServlet.this.m_provider);
                }
            }
        });
        SessionListenerRepository sessionListenerRepository = SessionListenerRepository.getRepository(this.m_context);
        if (sessionListenerRepository != null) {
            service.addSessionInitListener((SessionInitListener)sessionListenerRepository);
            service.addSessionDestroyListener((SessionDestroyListener)sessionListenerRepository);
        }
        service.addSessionInitListener(new SessionInitListener(){

            public void sessionInit(SessionInitEvent event) throws ServiceException {
                event.getSession().addBootstrapListener(new BootstrapListener(){

                    public void modifyBootstrapPage(BootstrapPageResponse response) {
                        response.getDocument().head().getElementsByAttributeValue("rel", "shortcut icon").attr("href", "/opennms/favicon.ico");
                        response.getDocument().head().getElementsByAttributeValue("rel", "icon").attr("href", "/opennms/favicon.ico");
                    }

                    public void modifyBootstrapFragment(BootstrapFragmentResponse response) {
                    }
                });
            }
        });
        return service;
    }
}

