/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.data;

import org.jrobin.core.RrdException;
import org.jrobin.data.Aggregates;
import org.jrobin.data.Source;

class SDef
extends Source {
    private String defName;
    private String consolFun;
    private double value;

    SDef(String name, String defName, String consolFun) {
        super(name);
        this.defName = defName;
        this.consolFun = consolFun;
    }

    String getDefName() {
        return this.defName;
    }

    String getConsolFun() {
        return this.consolFun;
    }

    void setValue(double value) {
        this.value = value;
        int count = this.getTimestamps().length;
        double[] values = new double[count];
        for (int i = 0; i < count; ++i) {
            values[i] = value;
        }
        this.setValues(values);
    }

    @Override
    Aggregates getAggregates(long tStart, long tEnd) throws RrdException {
        Aggregates agg = new Aggregates();
        agg.max = agg.average = this.value;
        agg.min = agg.average;
        agg.last = agg.average;
        agg.first = agg.average;
        agg.total = this.value * (double)(tEnd - tStart);
        return agg;
    }

    @Override
    double getPercentile(long tStart, long tEnd, double percentile) throws RrdException {
        return this.value;
    }
}

