/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.Util;

public class RrdFileBackend
extends RrdBackend {
    protected RandomAccessFile file;

    protected RrdFileBackend(String path, boolean readOnly) throws IOException {
        super(path, readOnly);
        this.file = new RandomAccessFile(path, readOnly ? "r" : "rw");
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    public static String getCanonicalPath(String path) throws IOException {
        return Util.getCanonicalPath(path);
    }

    public String getCanonicalPath() throws IOException {
        return RrdFileBackend.getCanonicalPath(this.getPath());
    }

    @Override
    protected void write(long offset, byte[] b) throws IOException {
        this.file.seek(offset);
        this.file.write(b);
    }

    @Override
    protected void read(long offset, byte[] b) throws IOException {
        this.file.seek(offset);
        if (this.file.read(b) != b.length) {
            throw new IOException("Not enough bytes available in file " + this.getPath());
        }
    }

    @Override
    public long getLength() throws IOException {
        return this.file.length();
    }

    @Override
    protected void setLength(long length) throws IOException {
        this.file.setLength(length);
    }
}

