/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.io.IOException;
import org.jrobin.cmd.ColonSplitter;
import org.jrobin.cmd.RrdToolCmd;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;

class RrdCreateCmd
extends RrdToolCmd {
    static final String DEFAULT_START = "now-10s";
    static final String DEFAULT_STEP = "300";
    private RrdDef rrdDef;

    RrdCreateCmd() {
    }

    @Override
    String getCmdType() {
        return "create";
    }

    @Override
    Object execute() throws RrdException, IOException {
        String startStr = this.getOptionValue("b", "start", DEFAULT_START);
        long start = Util.getTimestamp(startStr);
        String stepStr = this.getOptionValue("s", "step", DEFAULT_STEP);
        long step = RrdCreateCmd.parseLong(stepStr);
        String[] words = this.getRemainingWords();
        if (words.length < 2) {
            throw new RrdException("RRD file path not specified");
        }
        String path = words[1];
        this.rrdDef = new RrdDef(path, start, step);
        for (int i = 2; i < words.length; ++i) {
            if (words[i].startsWith("DS:")) {
                this.parseDef(words[i]);
                continue;
            }
            if (words[i].startsWith("RRA:")) {
                this.parseRra(words[i]);
                continue;
            }
            throw new RrdException("Invalid rrdcreate syntax: " + words[i]);
        }
        return this.createRrdDb();
    }

    private void parseDef(String word) throws RrdException {
        String[] tokens = new ColonSplitter(word).split();
        if (tokens.length < 6) {
            throw new RrdException("Invalid DS definition: " + word);
        }
        String dsName = tokens[1];
        String dsType = tokens[2];
        long heartbeat = RrdCreateCmd.parseLong(tokens[3]);
        double min = RrdCreateCmd.parseDouble(tokens[4]);
        double max = RrdCreateCmd.parseDouble(tokens[5]);
        this.rrdDef.addDatasource(dsName, dsType, heartbeat, min, max);
    }

    private void parseRra(String word) throws RrdException {
        String[] tokens = new ColonSplitter(word).split();
        if (tokens.length < 5) {
            throw new RrdException("Invalid RRA definition: " + word);
        }
        String cf = tokens[1];
        double xff = RrdCreateCmd.parseDouble(tokens[2]);
        int steps = RrdCreateCmd.parseInt(tokens[3]);
        int rows = RrdCreateCmd.parseInt(tokens[4]);
        this.rrdDef.addArchive(cf, xff, steps, rows);
    }

    private String createRrdDb() throws IOException, RrdException {
        RrdDb rrdDb = RrdCreateCmd.getRrdDbReference(this.rrdDef);
        RrdCreateCmd.releaseRrdDbReference(rrdDb);
        return this.rrdDef.getPath();
    }
}

