/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.tracker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ops4j.pax.web.extender.war.internal.tracker.ReplaceableServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceableService<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ReplaceableService.class);
    private final BundleContext bundleContext;
    private final Class<T> serviceClass;
    private final ReplaceableServiceListener<T> serviceListener;
    private final ServiceTracker<T, T> serviceTracker;
    private final List<ServiceReference<T>> boundReferences;
    private T service;

    public ReplaceableService(BundleContext context, Class<T> serviceClass, ReplaceableServiceListener<T> serviceListener) {
        this.bundleContext = context;
        this.serviceClass = serviceClass;
        this.serviceListener = serviceListener;
        this.serviceTracker = new ServiceTracker(context, serviceClass, (ServiceTrackerCustomizer)new Customizer());
        this.boundReferences = new ArrayList<ServiceReference<T>>();
    }

    public void start() {
        this.serviceTracker.open();
    }

    public void stop() {
        this.serviceTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bind(T serviceToBind) {
        if (this.serviceListener != null) {
            T oldService;
            ReplaceableService replaceableService = this;
            synchronized (replaceableService) {
                oldService = this.service;
                this.service = serviceToBind;
            }
            this.serviceListener.serviceChanged(oldService, serviceToBind);
        }
    }

    private class Customizer
    implements ServiceTrackerCustomizer<T, T> {
        private Customizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T addingService(ServiceReference<T> reference) {
            ServiceReference bind;
            Object bundleService = ReplaceableService.this.bundleContext.getService(reference);
            List list = ReplaceableService.this.boundReferences;
            synchronized (list) {
                ReplaceableService.this.boundReferences.add(reference);
                Collections.sort(ReplaceableService.this.boundReferences);
                bind = (ServiceReference)ReplaceableService.this.boundReferences.get(0);
            }
            if (bind == reference) {
                ReplaceableService.this.bind(bundleService);
            } else {
                ReplaceableService.this.bind(ReplaceableService.this.serviceTracker.getService(bind));
            }
            return bundleService;
        }

        public void modifiedService(ServiceReference<T> reference, T modifiedService) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<T> reference, T removedService) {
            ServiceReference bind;
            List list = ReplaceableService.this.boundReferences;
            synchronized (list) {
                ReplaceableService.this.boundReferences.remove(reference);
                bind = ReplaceableService.this.boundReferences.isEmpty() ? null : (ServiceReference)ReplaceableService.this.boundReferences.get(0);
            }
            if (bind == null) {
                ReplaceableService.this.bind(null);
            } else {
                ReplaceableService.this.bind(ReplaceableService.this.serviceTracker.getService(bind));
            }
            ReplaceableService.this.bundleContext.ungetService(reference);
        }
    }
}

