/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.exolab.castor.xml.util.resolvers;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.opennms.shaded.jasper.org.exolab.castor.mapping.ClassDescriptor;
import org.opennms.shaded.jasper.org.exolab.castor.mapping.Mapping;
import org.opennms.shaded.jasper.org.exolab.castor.mapping.MappingException;
import org.opennms.shaded.jasper.org.exolab.castor.mapping.MappingLoader;
import org.opennms.shaded.jasper.org.exolab.castor.xml.ResolverException;
import org.opennms.shaded.jasper.org.exolab.castor.xml.util.resolvers.AbstractResolverPackageCommand;
import org.opennms.shaded.jasper.org.exolab.castor.xml.util.resolvers.ResolveHelpers;

public class ByPackageMapping
extends AbstractResolverPackageCommand {
    private static final Log LOG = LogFactory.getLog(ByPackageMapping.class);
    private List<String> _loadedPackages = new ArrayList<String>();

    private Mapping loadMapping(String packageName, ClassLoader classLoader) throws MappingException {
        URL url = classLoader.getResource(ResolveHelpers.getQualifiedFileName(".castor.xml", packageName));
        if (url == null) {
            return null;
        }
        try {
            Mapping mapping = new Mapping(classLoader);
            mapping.loadMapping(url);
            return mapping;
        }
        catch (IOException ioex) {
            throw new MappingException(ioex);
        }
    }

    @Override
    protected Map<String, ClassDescriptor> internalResolve(String packageName, ClassLoader classLoader, Map properties) throws ResolverException {
        HashMap<String, ClassDescriptor> results;
        block8: {
            results = new HashMap<String, ClassDescriptor>();
            if (!this.isEmptyPackageName(packageName) && this._loadedPackages.contains(packageName)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Package: " + packageName + " has already been loaded."));
                }
                return results;
            }
            if (!this.isEmptyPackageName(packageName)) {
                this._loadedPackages.add(packageName);
            }
            try {
                Mapping mapping = this.loadMapping(packageName, classLoader);
                if (mapping != null) {
                    MappingUnmarshaller unmarshaller = new MappingUnmarshaller();
                    MappingLoader mappingLoader = unmarshaller.getMappingLoader(mapping, BindingType.XML);
                    for (ClassDescriptor classDescriptor : mappingLoader.getDescriptors()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Found descriptor: " + classDescriptor));
                        }
                        results.put(classDescriptor.getJavaClass().getName(), classDescriptor);
                    }
                }
            }
            catch (MappingException e) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)("Ignored exception: " + e + " while loading mapping for package: " + packageName));
            }
        }
        return results;
    }
}

