/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.com.lowagie.text.pdf.events;

import java.io.IOException;
import java.util.HashMap;
import org.opennms.shaded.jasper.com.lowagie.text.Document;
import org.opennms.shaded.jasper.com.lowagie.text.DocumentException;
import org.opennms.shaded.jasper.com.lowagie.text.ExceptionConverter;
import org.opennms.shaded.jasper.com.lowagie.text.Rectangle;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfContentByte;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfFormField;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfName;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfPCell;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfPCellEvent;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfPageEventHelper;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfRectangle;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfWriter;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.TextField;

public class FieldPositioningEvents
extends PdfPageEventHelper
implements PdfPCellEvent {
    protected HashMap genericChunkFields = new HashMap();
    protected PdfFormField cellField = null;
    protected PdfWriter fieldWriter = null;
    protected PdfFormField parent = null;
    public float padding;

    public FieldPositioningEvents() {
    }

    public void addField(String string, PdfFormField pdfFormField) {
        this.genericChunkFields.put(string, pdfFormField);
    }

    public FieldPositioningEvents(PdfWriter pdfWriter, PdfFormField pdfFormField) {
        this.cellField = pdfFormField;
        this.fieldWriter = pdfWriter;
    }

    public FieldPositioningEvents(PdfFormField pdfFormField, PdfFormField pdfFormField2) {
        this.cellField = pdfFormField2;
        this.parent = pdfFormField;
    }

    public FieldPositioningEvents(PdfWriter pdfWriter, String string) throws IOException, DocumentException {
        this.fieldWriter = pdfWriter;
        TextField textField = new TextField(pdfWriter, new Rectangle(0.0f, 0.0f), string);
        textField.setFontSize(14.0f);
        this.cellField = textField.getTextField();
    }

    public FieldPositioningEvents(PdfWriter pdfWriter, PdfFormField pdfFormField, String string) throws IOException, DocumentException {
        this.parent = pdfFormField;
        TextField textField = new TextField(pdfWriter, new Rectangle(0.0f, 0.0f), string);
        textField.setFontSize(14.0f);
        this.cellField = textField.getTextField();
    }

    public void setPadding(float f) {
        this.padding = f;
    }

    public void setParent(PdfFormField pdfFormField) {
        this.parent = pdfFormField;
    }

    public void onGenericTag(PdfWriter pdfWriter, Document document, Rectangle rectangle, String string) {
        rectangle.setBottom(rectangle.getBottom() - 3.0f);
        PdfFormField pdfFormField = (PdfFormField)this.genericChunkFields.get(string);
        if (pdfFormField == null) {
            TextField textField = new TextField(pdfWriter, new Rectangle(rectangle.getLeft(this.padding), rectangle.getBottom(this.padding), rectangle.getRight(this.padding), rectangle.getTop(this.padding)), string);
            textField.setFontSize(14.0f);
            try {
                pdfFormField = textField.getTextField();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        } else {
            pdfFormField.put(PdfName.RECT, new PdfRectangle(rectangle.getLeft(this.padding), rectangle.getBottom(this.padding), rectangle.getRight(this.padding), rectangle.getTop(this.padding)));
        }
        if (this.parent == null) {
            pdfWriter.addAnnotation(pdfFormField);
        } else {
            this.parent.addKid(pdfFormField);
        }
    }

    public void cellLayout(PdfPCell pdfPCell, Rectangle rectangle, PdfContentByte[] pdfContentByteArray) {
        if (this.cellField == null || this.fieldWriter == null && this.parent == null) {
            throw new ExceptionConverter(new IllegalArgumentException("You have used the wrong constructor for this FieldPositioningEvents class."));
        }
        this.cellField.put(PdfName.RECT, new PdfRectangle(rectangle.getLeft(this.padding), rectangle.getBottom(this.padding), rectangle.getRight(this.padding), rectangle.getTop(this.padding)));
        if (this.parent == null) {
            this.fieldWriter.addAnnotation(this.cellField);
        } else {
            this.parent.addKid(this.cellField);
        }
    }
}

