/*
 * Decompiled with CFR 0.152.
 */
package org.castor.xml;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.castor.xml.InternalContext;
import org.castor.xml.JavaNaming;

public class JavaNamingNGImpl
implements JavaNaming {
    public static final String UPPER_CASE_AFTER_UNDERSCORE_PROPERTY = "org.opennms.shaded.jasper.org.exolab.castor.xml.JavaNaming.upperCaseAfterUnderscore";
    public static boolean _upperCaseAfterUnderscore = false;
    private static final Hashtable<String, String> SUBST = JavaNamingNGImpl.keywordMap();
    private InternalContext context;
    private static final Set<String> KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while")));

    public JavaNamingNGImpl() {
    }

    public JavaNamingNGImpl(InternalContext context) {
        this.context = context;
    }

    @Override
    public final boolean isKeyword(String name) {
        return KEYWORDS.contains(name);
    }

    @Override
    public final boolean isValidJavaIdentifier(String string) {
        if (string == null || string.length() == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            return false;
        }
        return !this.isKeyword(string);
    }

    @Override
    public final String toJavaClassName(String name) {
        if (name == null || name.length() <= 0) {
            return name;
        }
        int colon = name.indexOf(58);
        if (colon != -1) {
            return this.toJavaName(name.substring(colon + 1), true);
        }
        return this.toJavaName(name, true);
    }

    @Override
    public final String toJavaMemberName(String name) {
        return this.toJavaMemberName(name, true);
    }

    @Override
    public final String toJavaMemberName(String name, boolean useKeywordSubstitutions) {
        String mappedName;
        if (name == null) {
            return null;
        }
        String memberName = this.toJavaName(name, false);
        if (this.isKeyword(memberName) && useKeywordSubstitutions && (mappedName = SUBST.get(memberName)) != null) {
            memberName = mappedName;
        }
        return memberName;
    }

    @Override
    public final boolean isValidPackageName(String packageName) {
        if (packageName == null || packageName.length() < 1) {
            return true;
        }
        if (".".equals(packageName)) {
            return false;
        }
        if (packageName.startsWith(".") || packageName.endsWith(".")) {
            return false;
        }
        boolean valid = true;
        String[] packageNameParts = packageName.split("\\.");
        for (int i = 0; i < packageNameParts.length; ++i) {
            String packageNamePart = packageNameParts[i];
            valid &= this.isValidJavaIdentifier(packageNamePart);
        }
        return valid;
    }

    @Override
    public final String packageToPath(String packageName) {
        if (packageName == null) {
            return packageName;
        }
        if (!this.isValidPackageName(packageName)) {
            String message = "Package name: " + packageName + " is not valid";
            throw new IllegalArgumentException(message);
        }
        return packageName.replace('.', File.separatorChar);
    }

    private static Hashtable<String, String> keywordMap() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("class", "clazz");
        return ht;
    }

    private String toJavaName(String name, boolean upperFirst) {
        boolean lowercase;
        int size = name.length();
        char[] ncChars = name.toCharArray();
        int next = 0;
        boolean uppercase = upperFirst;
        boolean bl = lowercase = !uppercase;
        if (size > 1 && lowercase && Character.isUpperCase(ncChars[0]) && Character.isUpperCase(ncChars[1])) {
            lowercase = this.context != null && this.context.getBooleanProperty("org.opennms.shaded.jasper.org.exolab.castor.xml.member.naming.capitalisation.strict") != false;
        }
        block5: for (int i = 0; i < size; ++i) {
            char ch = ncChars[i];
            switch (ch) {
                case ' ': 
                case '.': {
                    ncChars[next++] = 95;
                    continue block5;
                }
                case '-': 
                case ':': {
                    uppercase = true;
                    continue block5;
                }
                case '_': {
                    if (_upperCaseAfterUnderscore) {
                        uppercase = true;
                        ncChars[next] = ch;
                        ++next;
                        continue block5;
                    }
                }
                default: {
                    if (uppercase) {
                        ncChars[next] = Character.toUpperCase(ch);
                        uppercase = false;
                    } else if (lowercase) {
                        ncChars[next] = Character.toLowerCase(ch);
                        lowercase = false;
                    } else {
                        ncChars[next] = ch;
                    }
                    ++next;
                }
            }
        }
        return new String(ncChars, 0, next);
    }

    @Override
    public final String getQualifiedFileName(String fileName, String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return fileName;
        }
        return this.packageToPath(packageName) + '/' + fileName;
    }

    @Override
    public final String getPackageName(String className) {
        if (className == null || className.length() < 1) {
            return className;
        }
        int idx = className.lastIndexOf(46);
        if (idx >= 0) {
            return className.substring(0, idx);
        }
        return "";
    }

    @Override
    public final String extractFieldNameFromMethod(Method method) {
        if (method == null) {
            return null;
        }
        String fieldName = null;
        if (this.isSetMethod(method)) {
            fieldName = method.getName().substring("set".length());
        } else if (this.isCreateMethod(method)) {
            fieldName = method.getName().substring("create".length());
        } else if (this.isGetMethod(method)) {
            fieldName = method.getName().substring("get".length());
        } else if (this.isIsMethod(method)) {
            fieldName = method.getName().substring("is".length());
        } else if (this.isAddMethod(method)) {
            fieldName = method.getName().substring("add".length());
        }
        return this.toJavaMemberName(fieldName);
    }

    @Override
    public final String extractFieldNameFromField(Field field) {
        if (field == null) {
            return null;
        }
        String fieldName = field.getName();
        if (fieldName.charAt(0) == '_') {
            fieldName = fieldName.substring(1);
        }
        return fieldName;
    }

    @Override
    public final boolean isSetMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith("set")) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        return method.getReturnType() == Void.TYPE || method.getReturnType() == Void.class;
    }

    @Override
    public final boolean isCreateMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith("create")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return method.getReturnType() != null;
    }

    @Override
    public final boolean isGetMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith("get")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return method.getReturnType() != null;
    }

    @Override
    public final boolean isIsMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith("is")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        if (method.getReturnType().isPrimitive() && method.getReturnType() != Boolean.TYPE) {
            return false;
        }
        return method.getReturnType().isPrimitive() || method.getReturnType() == Boolean.class;
    }

    @Override
    public final boolean isAddMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith("add")) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        return method.getReturnType() == Void.TYPE || method.getReturnType() == Void.class;
    }

    @Override
    public final String getAddMethodNameForField(String fieldName) {
        return "add" + this.toJavaClassName(fieldName);
    }

    @Override
    public final String getCreateMethodNameForField(String fieldName) {
        return "create" + this.toJavaClassName(fieldName);
    }

    @Override
    public final String getGetMethodNameForField(String fieldName) {
        return "get" + this.toJavaClassName(fieldName);
    }

    @Override
    public final String getIsMethodNameForField(String fieldName) {
        return "is" + this.toJavaClassName(fieldName);
    }

    @Override
    public final String getSetMethodNameForField(String fieldName) {
        return "set" + this.toJavaClassName(fieldName);
    }

    @Override
    public String getClassName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String name = clazz.getName();
        int idx = name.lastIndexOf(46);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        return name;
    }
}

